/*
 * Decompiled with CFR 0.152.
 */
package redis.clients.jedis.search;

import java.util.Collection;
import java.util.function.IntFunction;
import redis.clients.jedis.CommandArguments;
import redis.clients.jedis.providers.ConnectionProvider;
import redis.clients.jedis.search.Document;
import redis.clients.jedis.search.FTSearchParams;
import redis.clients.jedis.search.Query;
import redis.clients.jedis.search.SearchProtocol;
import redis.clients.jedis.search.SearchResult;
import redis.clients.jedis.util.JedisCommandIterationBase;

public class FtSearchIteration
extends JedisCommandIterationBase<SearchResult, Document> {
    private int batchStart;
    private final int batchSize;
    private final IntFunction<CommandArguments> args;

    public FtSearchIteration(ConnectionProvider connectionProvider, int batchSize, String indexName, String query, FTSearchParams params) {
        super(connectionProvider, new SearchResult.SearchResultBuilder(!params.getNoContent(), params.getWithScores(), false, true));
        this.batchSize = batchSize;
        this.args = limitFirst -> new CommandArguments(SearchProtocol.SearchCommand.SEARCH).add(indexName).add(query).addParams(params.limit(limitFirst, this.batchSize));
    }

    public FtSearchIteration(ConnectionProvider connectionProvider, int batchSize, String indexName, Query query) {
        super(connectionProvider, new SearchResult.SearchResultBuilder(!query.getNoContent(), query.getWithScores(), query.getWithPayloads(), true));
        this.batchSize = batchSize;
        this.args = limitFirst -> new CommandArguments(SearchProtocol.SearchCommand.SEARCH).add(indexName).addParams(query.limit(limitFirst, this.batchSize));
    }

    @Override
    protected boolean isNodeCompleted(SearchResult reply) {
        return (long)this.batchStart >= reply.getTotalResults() - (long)this.batchSize;
    }

    @Override
    protected CommandArguments initCommandArguments() {
        this.batchStart = 0;
        return this.args.apply(this.batchStart);
    }

    @Override
    protected CommandArguments nextCommandArguments(SearchResult lastReply) {
        this.batchStart += this.batchSize;
        return this.args.apply(this.batchStart);
    }

    @Override
    protected Collection<Document> convertBatchToData(SearchResult batch) {
        return batch.getDocuments();
    }
}

