/*
 * Decompiled with CFR 0.152.
 */
package pl.project13.maven.git;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Pattern;
import pl.project13.maven.git.ReplacementProperty;
import pl.project13.maven.git.TransformationRule;
import pl.project13.maven.git.log.LoggerBridge;

public class PropertiesReplacer {
    private final LoggerBridge log;

    public PropertiesReplacer(LoggerBridge log) {
        this.log = log;
    }

    public void performReplacement(Properties properties, List<ReplacementProperty> replacementProperties) {
        if (replacementProperties != null && properties != null) {
            for (ReplacementProperty replacementProperty : replacementProperties) {
                String propertyKey = replacementProperty.getProperty();
                if (propertyKey == null) {
                    HashMap<String, String> propertiesToBeAdded = new HashMap<String, String>();
                    for (Map.Entry<Object, Object> entry : properties.entrySet()) {
                        String key = (String)entry.getKey();
                        String content = (String)entry.getValue();
                        String result = this.performReplacement(replacementProperty, content);
                        if (replacementProperty.getPropertyOutputSuffix() != null && !replacementProperty.getPropertyOutputSuffix().isEmpty()) {
                            String newPropertyKey = key + "." + replacementProperty.getPropertyOutputSuffix();
                            propertiesToBeAdded.put(newPropertyKey, result);
                            this.log.info("apply replace on property " + key + " and save to " + newPropertyKey + ": original value '" + content + "' with '" + result + "'");
                            continue;
                        }
                        entry.setValue(result);
                        this.log.info("apply replace on property " + key + ": original value '" + content + "' with '" + result + "'");
                    }
                    properties.putAll((Map<?, ?>)propertiesToBeAdded);
                    continue;
                }
                String content = properties.getProperty(propertyKey);
                String result = this.performReplacement(replacementProperty, content);
                if (replacementProperty.getPropertyOutputSuffix() != null && !replacementProperty.getPropertyOutputSuffix().isEmpty()) {
                    String newPropertyKey = propertyKey + "." + replacementProperty.getPropertyOutputSuffix();
                    properties.setProperty(newPropertyKey, result);
                    this.log.info("apply replace on property " + propertyKey + " and save to " + newPropertyKey + ": original value '" + content + "' with '" + result + "'");
                    continue;
                }
                properties.setProperty(propertyKey, result);
                this.log.info("apply replace on property " + propertyKey + ": original value '" + content + "' with '" + result + "'");
            }
        }
    }

    private String performReplacement(ReplacementProperty replacementProperty, String content) {
        String result = content;
        if (replacementProperty != null) {
            result = this.performTransformationRules(replacementProperty, result, TransformationRule.ApplyEnum.BEFORE);
            result = replacementProperty.isRegex() ? this.replaceRegex(result, replacementProperty.getToken(), replacementProperty.getValue()) : this.replaceNonRegex(result, replacementProperty.getToken(), replacementProperty.getValue());
            result = this.performTransformationRules(replacementProperty, result, TransformationRule.ApplyEnum.AFTER);
        }
        return result;
    }

    private String performTransformationRules(ReplacementProperty replacementProperty, String content, TransformationRule.ApplyEnum forRule) {
        String result = content;
        if (replacementProperty.getTransformationRules() != null && !replacementProperty.getTransformationRules().isEmpty()) {
            for (TransformationRule transformationRule : replacementProperty.getTransformationRules()) {
                if (!transformationRule.getApplyRule().equals((Object)forRule)) continue;
                result = transformationRule.getActionRule().perform(result);
            }
        }
        return result;
    }

    private String replaceRegex(String content, String token, String value) {
        if (token == null) {
            this.log.error("found replacementProperty without required token.");
            return content;
        }
        Pattern compiledPattern = Pattern.compile(token);
        return compiledPattern.matcher(content).replaceAll(value == null ? "" : value);
    }

    private String replaceNonRegex(String content, String token, String value) {
        if (token == null) {
            this.log.error("found replacementProperty without required token.");
            return content;
        }
        return content.replace(token, value == null ? "" : value);
    }
}

