/*
 * Decompiled with CFR 0.152.
 */
package junitparams.mappers;

import java.io.BufferedReader;
import java.io.Reader;
import java.util.LinkedList;
import junitparams.mappers.DataMapper;

class BufferedReaderDataMapper
implements DataMapper {
    private final int linesToSkip;

    BufferedReaderDataMapper() {
        this(0);
    }

    BufferedReaderDataMapper(int linesToSkip) {
        this.linesToSkip = linesToSkip;
    }

    @Override
    public Object[] map(Reader reader) {
        BufferedReader br = new BufferedReader(reader);
        LinkedList<String> result = new LinkedList<String>();
        int lineNo = 0;
        try {
            String line;
            while ((line = br.readLine()) != null) {
                if (++lineNo <= this.linesToSkip) continue;
                result.add(line);
            }
            return result.toArray();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

