/*
 * Decompiled with CFR 0.152.
 */
package junitparams.internal.parameters.toarray;

import junitparams.internal.parameters.toarray.ResultToArray;
import org.junit.runners.model.FrameworkMethod;

class ObjectArrayResultToArray
implements ResultToArray {
    private Object result;
    private FrameworkMethod frameworkMethod;

    ObjectArrayResultToArray(Object result, FrameworkMethod frameworkMethod) {
        this.result = result;
        this.frameworkMethod = frameworkMethod;
    }

    @Override
    public boolean isApplicable() {
        return Object[].class.isAssignableFrom(this.result.getClass());
    }

    @Override
    public Object[] convert() {
        return this.encapsulateParamsIntoArrayIfSingleParamsetPassed((Object[])this.result);
    }

    private Object[] encapsulateParamsIntoArrayIfSingleParamsetPassed(Object[] params) {
        if (this.frameworkMethod.getMethod().getParameterTypes().length != params.length) {
            return params;
        }
        if (params.length == 0) {
            return params;
        }
        Object param = params[0];
        if (param == null || !param.getClass().isArray()) {
            return new Object[]{params};
        }
        return params;
    }
}

