/*
 * Decompiled with CFR 0.152.
 */
package junitparams.naming;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Locale;
import java.util.regex.Pattern;
import junitparams.internal.Utils;
import junitparams.naming.TestCaseName;
import junitparams.naming.TestCaseNamingStrategy;

public class MacroSubstitutionNamingStrategy
implements TestCaseNamingStrategy {
    private static final String MACRO_PATTERN = "\\{[^\\}]{0,50}\\}";
    private static final Pattern MACRO_SPLIT_PATTERN = Pattern.compile(String.format("(?=%s)|(?<=%s)", "\\{[^\\}]{0,50}\\}", "\\{[^\\}]{0,50}\\}"));
    private static final String MACRO_START = "{";
    private static final String MACRO_END = "}";
    static final String DEFAULT_TEMPLATE = "{method}({params}) [{index}]";
    private static final String[] DEFAULT_TEMPLATE_PARTS = MACRO_SPLIT_PATTERN.split("{method}({params}) [{index}]");
    private String[] templateParts;
    private String methodName;

    public MacroSubstitutionNamingStrategy(TestCaseName testCaseName, String methodName) {
        this.templateParts = MACRO_SPLIT_PATTERN.split(MacroSubstitutionNamingStrategy.getTemplate(testCaseName));
        this.methodName = methodName;
    }

    public static String getTemplate(TestCaseName testCaseName) {
        if (testCaseName != null) {
            return testCaseName.value();
        }
        return DEFAULT_TEMPLATE;
    }

    @Override
    public String getTestCaseName(int parametersIndex, Object parameters) {
        String builtName = this.buildNameByTemplate(this.templateParts, parametersIndex, parameters);
        if (builtName.trim().isEmpty()) {
            return this.buildNameByTemplate(DEFAULT_TEMPLATE_PARTS, parametersIndex, parameters);
        }
        return builtName;
    }

    private String buildNameByTemplate(String[] parts, int parametersIndex, Object parameters) {
        StringBuilder nameBuilder = new StringBuilder();
        for (String part : parts) {
            String transformedPart = this.transformPart(part, parametersIndex, parameters);
            nameBuilder.append(transformedPart);
        }
        return nameBuilder.toString();
    }

    private String transformPart(String part, int parametersIndex, Object parameters) {
        if (this.isMacro(part)) {
            return this.lookupMacroValue(part, parametersIndex, parameters);
        }
        return part;
    }

    private String lookupMacroValue(String macro, int parametersIndex, Object parameters) {
        String macroKey = this.getMacroKey(macro);
        switch (Macro.parse(macroKey)) {
            case INDEX: {
                return String.valueOf(parametersIndex);
            }
            case PARAMS: {
                return Utils.stringify(parameters);
            }
            case METHOD: {
                return this.methodName;
            }
        }
        return this.substituteDynamicMacro(macro, macroKey, parameters);
    }

    private String substituteDynamicMacro(String macro, String macroKey, Object parameters) {
        if (this.isMethodParameterIndex(macroKey)) {
            int index = this.parseIndex(macroKey);
            return Utils.getParameterStringByIndexOrEmpty(parameters, index);
        }
        return macro;
    }

    private boolean isMethodParameterIndex(String macroKey) {
        return macroKey.matches("\\d+");
    }

    private int parseIndex(String macroKey) {
        return Integer.parseInt(macroKey);
    }

    private String getMacroKey(String macro) {
        return macro.substring(MACRO_START.length(), macro.length() - MACRO_END.length()).toUpperCase(Locale.ENGLISH);
    }

    private boolean isMacro(String part) {
        return part.startsWith(MACRO_START) && part.endsWith(MACRO_END);
    }

    private static enum Macro {
        INDEX,
        PARAMS,
        METHOD,
        NONE;

        private static final HashSet<String> macros;

        public static Macro parse(String value) {
            if (macros.contains(value)) {
                return Macro.valueOf(value);
            }
            return NONE;
        }

        static {
            macros = new HashSet<String>(Arrays.asList(INDEX.toString(), PARAMS.toString(), METHOD.toString()));
        }
    }
}

