/*
 * Decompiled with CFR 0.152.
 */
package junitparams.internal;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public class Utils {
    private static Map<Character, Character> SPECIAL_CHARACTERS_REPLACEMENTS = Utils.replacements();

    public static String stringify(Object paramSet, int paramIdx) {
        String result = "[" + paramIdx + "] ";
        return result + Utils.stringify(paramSet);
    }

    public static String stringify(Object paramSet) {
        String result = paramSet == null ? "null" : (paramSet instanceof String ? paramSet.toString() : Utils.asCsvString(Utils.safelyCastParamsToArray(paramSet)));
        return Utils.trimSpecialChars(result);
    }

    public static String getParameterStringByIndexOrEmpty(Object paramSet, int parameterIndex) {
        Object[] params = Utils.safelyCastParamsToArray(paramSet);
        if (paramSet instanceof String) {
            params = Utils.splitAtCommaOrPipe((String)paramSet);
        }
        if (parameterIndex >= 0 && parameterIndex < params.length) {
            return Utils.addParamToResult("", params[parameterIndex]);
        }
        return "";
    }

    public static String[] splitAtCommaOrPipe(String input) {
        ArrayList<String> result = new ArrayList<String>();
        char character = '\u0000';
        StringBuilder value = new StringBuilder();
        for (int i = 0; i < input.length(); ++i) {
            char previousCharacter = character;
            character = input.charAt(i);
            if (character == ',' || character == '|') {
                if (previousCharacter == '\\') {
                    value.setCharAt(value.length() - 1, character);
                    continue;
                }
                result.add(value.toString().trim());
                value = new StringBuilder();
                continue;
            }
            value.append(character);
        }
        result.add(value.toString().trim());
        return result.toArray(new String[0]);
    }

    private static String trimSpecialChars(String result) {
        StringBuilder sb = new StringBuilder(result.length());
        for (int i = 0; i < result.length(); ++i) {
            char c = result.charAt(i);
            if (SPECIAL_CHARACTERS_REPLACEMENTS.containsKey(Character.valueOf(c))) {
                sb.append(SPECIAL_CHARACTERS_REPLACEMENTS.get(Character.valueOf(c)));
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    private static Map<Character, Character> replacements() {
        HashMap<Character, Character> replacements = new HashMap<Character, Character>();
        replacements.put(Character.valueOf('('), Character.valueOf('['));
        replacements.put(Character.valueOf(')'), Character.valueOf(']'));
        replacements.put(Character.valueOf('\n'), Character.valueOf(' '));
        replacements.put(Character.valueOf('\r'), Character.valueOf(' '));
        return replacements;
    }

    static Object[] safelyCastParamsToArray(Object paramSet) {
        Object[] params = paramSet instanceof Object[] ? (Object[])paramSet : new Object[]{paramSet};
        return params;
    }

    private static String asCsvString(Object[] params) {
        if (params == null) {
            return "null";
        }
        if (params.length == 0) {
            return "";
        }
        String result = "";
        for (int i = 0; i < params.length - 1; ++i) {
            Object param = params[i];
            result = Utils.addParamToResult(result, param) + ", ";
        }
        result = Utils.addParamToResult(result, params[params.length - 1]);
        return result;
    }

    private static String addParamToResult(String result, Object param) {
        result = param == null ? result + "null" : (param.getClass().isArray() ? result + Utils.convertAnyArrayToString(param) : (Utils.hasOverridenToStringMethod(param) ? result + param.toString() : result + param.getClass().getSimpleName()));
        return result;
    }

    private static boolean hasOverridenToStringMethod(Object param) {
        Method[] methods;
        for (Method method : methods = param.getClass().getMethods()) {
            if (!method.getName().equals("toString") || !Utils.overridesMethod(method)) continue;
            return true;
        }
        return false;
    }

    private static boolean overridesMethod(Method method) {
        return !method.getDeclaringClass().equals(Object.class);
    }

    static String uniqueMethodId(int index, Object paramSet, String methodName) {
        return Utils.stringify(paramSet, index) + " (" + methodName + ")";
    }

    private static String convertAnyArrayToString(Object arrayAsObject) {
        if (arrayAsObject.getClass().getComponentType().isPrimitive()) {
            return Utils.convertFromArrayOfPrimitives(arrayAsObject);
        }
        return Arrays.toString((Object[])arrayAsObject);
    }

    private static String convertFromArrayOfPrimitives(Object arrayOfPrimitives) {
        String componentType = arrayOfPrimitives.getClass().getComponentType().getName();
        if ("byte".equals(componentType)) {
            return Arrays.toString((byte[])arrayOfPrimitives);
        }
        if ("short".equals(componentType)) {
            return Arrays.toString((short[])arrayOfPrimitives);
        }
        if ("int".equals(componentType)) {
            return Arrays.toString((int[])arrayOfPrimitives);
        }
        if ("long".equals(componentType)) {
            return Arrays.toString((long[])arrayOfPrimitives);
        }
        if ("float".equals(componentType)) {
            return Arrays.toString((float[])arrayOfPrimitives);
        }
        if ("double".equals(componentType)) {
            return Arrays.toString((double[])arrayOfPrimitives);
        }
        if ("boolean".equals(componentType)) {
            return Arrays.toString((boolean[])arrayOfPrimitives);
        }
        return Arrays.toString((char[])arrayOfPrimitives);
    }
}

