/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.embeddedelasticsearch;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.Proxy;
import java.net.URL;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.io.IOUtils;
import pl.allegro.tech.embeddedelasticsearch.ElasticRestClient;
import pl.allegro.tech.embeddedelasticsearch.ElasticSearchInstaller;
import pl.allegro.tech.embeddedelasticsearch.ElasticServer;
import pl.allegro.tech.embeddedelasticsearch.HttpClient;
import pl.allegro.tech.embeddedelasticsearch.IndexRequest;
import pl.allegro.tech.embeddedelasticsearch.IndexSettings;
import pl.allegro.tech.embeddedelasticsearch.IndicesDescription;
import pl.allegro.tech.embeddedelasticsearch.InstallFromDirectUrl;
import pl.allegro.tech.embeddedelasticsearch.InstallFromResources;
import pl.allegro.tech.embeddedelasticsearch.InstallFromVersion;
import pl.allegro.tech.embeddedelasticsearch.InstallationDescription;
import pl.allegro.tech.embeddedelasticsearch.InstallationSource;
import pl.allegro.tech.embeddedelasticsearch.InstanceSettings;
import pl.allegro.tech.embeddedelasticsearch.JavaHomeOption;
import pl.allegro.tech.embeddedelasticsearch.Require;
import pl.allegro.tech.embeddedelasticsearch.TemplatesDescription;

public final class EmbeddedElastic {
    private final String esJavaOpts;
    private final InstanceSettings instanceSettings;
    private final IndicesDescription indicesDescription;
    private final TemplatesDescription templatesDescription;
    private final InstallationDescription installationDescription;
    private final long startTimeoutInMs;
    private ElasticServer elasticServer;
    private ElasticRestClient elasticRestClient;
    private volatile boolean started = false;
    private final JavaHomeOption javaHome;

    public static Builder builder() {
        return new Builder();
    }

    private EmbeddedElastic(String esJavaOpts, InstanceSettings instanceSettings, IndicesDescription indicesDescription, TemplatesDescription templatesDescription, InstallationDescription installationDescription, long startTimeoutInMs, JavaHomeOption javaHome) {
        this.esJavaOpts = esJavaOpts;
        this.instanceSettings = instanceSettings;
        this.indicesDescription = indicesDescription;
        this.templatesDescription = templatesDescription;
        this.installationDescription = installationDescription;
        this.startTimeoutInMs = startTimeoutInMs;
        this.javaHome = javaHome;
    }

    public synchronized EmbeddedElastic start() throws IOException, InterruptedException {
        if (!this.started) {
            this.started = true;
            this.installElastic();
            this.startElastic();
            this.createRestClient();
            this.createTemplates();
            this.createIndices();
        }
        return this;
    }

    private void installElastic() throws IOException, InterruptedException {
        ElasticSearchInstaller elasticSearchInstaller = new ElasticSearchInstaller(this.instanceSettings, this.installationDescription);
        elasticSearchInstaller.install();
        File executableFile = elasticSearchInstaller.getExecutableFile();
        File installationDirectory = elasticSearchInstaller.getInstallationDirectory();
        this.elasticServer = new ElasticServer(this.esJavaOpts, installationDirectory, executableFile, this.startTimeoutInMs, this.installationDescription.isCleanInstallationDirectoryOnStop(), this.javaHome);
    }

    private void startElastic() throws IOException, InterruptedException {
        if (!this.elasticServer.isStarted()) {
            this.elasticServer.start();
        }
    }

    private void createRestClient() throws UnknownHostException {
        this.elasticRestClient = new ElasticRestClient(this.elasticServer.getHttpPort(), new HttpClient(), this.indicesDescription, this.templatesDescription);
    }

    public synchronized void stop() {
        if (this.elasticServer != null && this.started) {
            this.started = false;
            this.elasticServer.stop();
        }
    }

    public void index(String indexName, String indexType, Map<CharSequence, CharSequence> idJsonMap) {
        this.index(idJsonMap.entrySet().stream().map(entry -> new IndexRequest.IndexRequestBuilder(indexName, indexType, ((CharSequence)entry.getValue()).toString()).withId(((CharSequence)entry.getKey()).toString()).build()).collect(Collectors.toList()));
    }

    public void index(String indexName, String indexType, String ... json) {
        this.index(Arrays.stream(json).map(item -> new IndexRequest.IndexRequestBuilder(indexName, indexType, (String)item).build()).collect(Collectors.toList()));
    }

    public void index(String indexName, String indexType, List<CharSequence> jsons) {
        this.index(jsons.stream().map(json -> new IndexRequest.IndexRequestBuilder(indexName, indexType, json.toString()).build()).collect(Collectors.toList()));
    }

    public void index(List<IndexRequest> indexRequests) {
        this.elasticRestClient.bulkIndex(indexRequests);
    }

    public void recreateIndices() {
        this.deleteIndices();
        this.createIndices();
    }

    public void recreateIndex(String indexName) {
        this.deleteIndex(indexName);
        this.createIndex(indexName);
    }

    public void deleteIndices() {
        this.elasticRestClient.deleteIndices();
    }

    public void deleteIndex(String indexName) {
        this.elasticRestClient.deleteIndex(indexName);
    }

    public void createIndices() {
        this.elasticRestClient.createIndices();
    }

    public void createIndex(String indexName) {
        this.elasticRestClient.createIndex(indexName);
    }

    public void createTemplates() {
        this.elasticRestClient.createTemplates();
    }

    public void recreateTemplates() {
        this.deleteTemplates();
        this.createTemplates();
    }

    public void recreateTemplate(String templateName) {
        this.deleteTemplate(templateName);
        this.createTemplate(templateName);
    }

    public void deleteTemplates() {
        this.elasticRestClient.deleteTemplates();
    }

    public void deleteTemplate(String templateName) {
        this.elasticRestClient.deleteTemplate(templateName);
    }

    public void createTemplate(String templateName) {
        this.elasticRestClient.createTemplate(templateName);
    }

    public void refreshIndices() {
        this.elasticRestClient.refresh();
    }

    public List<String> fetchAllDocuments(String ... indices) throws UnknownHostException {
        return this.elasticRestClient.fetchAllDocuments(indices);
    }

    public int getTransportTcpPort() {
        return this.elasticServer.getTransportTcpPort();
    }

    public int getHttpPort() {
        return this.elasticServer.getHttpPort();
    }

    public static final class Builder {
        private InstallationSource installationSource = null;
        private List<InstallationDescription.Plugin> plugins = new ArrayList<InstallationDescription.Plugin>();
        private Map<String, Optional<IndexSettings>> indices = new HashMap<String, Optional<IndexSettings>>();
        private Map<String, String> templates = new HashMap<String, String>();
        private InstanceSettings settings = new InstanceSettings();
        private String esJavaOpts = "";
        private long startTimeoutInMs = 15000L;
        private boolean cleanInstallationDirectoryOnStop = true;
        private File installationDirectory = null;
        private File downloadDirectory = null;
        private int downloaderConnectionTimeoutInMs = 3000;
        private int downloaderReadTimeoutInMs = 300000;
        private Proxy downloadProxy = null;
        private JavaHomeOption javaHome = JavaHomeOption.useSystem();

        private Builder() {
        }

        public Builder withSetting(String name, Object value) {
            this.settings = this.settings.withSetting(name, value);
            return this;
        }

        public Builder withEsJavaOpts(String javaOpts) {
            this.esJavaOpts = javaOpts;
            return this;
        }

        public Builder withInstallationDirectory(File installationDirectory) {
            this.installationDirectory = installationDirectory;
            return this;
        }

        public Builder withDownloadDirectory(File downloadDirectory) {
            this.downloadDirectory = downloadDirectory;
            return this;
        }

        public Builder withCleanInstallationDirectoryOnStop(boolean cleanInstallationDirectoryOnStop) {
            this.cleanInstallationDirectoryOnStop = cleanInstallationDirectoryOnStop;
            return this;
        }

        public Builder withElasticVersion(String version) {
            this.installationSource = new InstallFromVersion(version);
            return this;
        }

        public Builder withDownloadUrl(URL downloadUrl) {
            this.installationSource = new InstallFromDirectUrl(downloadUrl);
            return this;
        }

        public Builder withInResourceLocation(String inResourcePath) {
            this.installationSource = new InstallFromResources(inResourcePath);
            return this;
        }

        public Builder withPlugin(String expression) {
            this.plugins.add(new InstallationDescription.Plugin(expression));
            return this;
        }

        public Builder withIndex(String indexName, IndexSettings indexSettings) {
            this.indices.put(indexName, Optional.of(indexSettings));
            return this;
        }

        public Builder withIndex(String indexName) {
            this.indices.put(indexName, Optional.empty());
            return this;
        }

        public Builder withTemplate(String name, String templateBody) {
            this.templates.put(name, templateBody);
            return this;
        }

        public Builder withTemplate(String name, InputStream templateBody) throws IOException {
            return this.withTemplate(name, IOUtils.toString((InputStream)templateBody, (Charset)StandardCharsets.UTF_8));
        }

        public Builder withStartTimeout(long value, TimeUnit unit) {
            this.startTimeoutInMs = unit.toMillis(value);
            return this;
        }

        public Builder withDownloaderConnectionTimeout(long value, TimeUnit unit) {
            this.downloaderConnectionTimeoutInMs = (int)unit.toMillis(value);
            return this;
        }

        public Builder withDownloaderReadTimeout(long value, TimeUnit unit) {
            this.downloaderReadTimeoutInMs = (int)unit.toMillis(value);
            return this;
        }

        public Builder withDownloadProxy(Proxy proxy) {
            this.downloadProxy = proxy;
            return this;
        }

        public Builder withJavaHome(JavaHomeOption javaHome) {
            this.javaHome = javaHome;
            return this;
        }

        public EmbeddedElastic build() {
            Require.require(this.installationSource != null, "You must specify elasticsearch version, or download url");
            return new EmbeddedElastic(this.esJavaOpts, this.settings, new IndicesDescription(this.indices), new TemplatesDescription(this.templates), new InstallationDescription(this.installationSource, this.downloadDirectory, this.installationDirectory, this.cleanInstallationDirectoryOnStop, this.plugins, this.downloaderConnectionTimeoutInMs, this.downloaderReadTimeoutInMs, this.downloadProxy), this.startTimeoutInMs, this.javaHome);
        }
    }
}

