/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.embeddedelasticsearch;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.Collections;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.SystemUtils;
import org.rauschig.jarchivelib.Archiver;
import org.rauschig.jarchivelib.ArchiverFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pl.allegro.tech.embeddedelasticsearch.ElasticDownloader;
import pl.allegro.tech.embeddedelasticsearch.EmbeddedElasticsearchStartupException;
import pl.allegro.tech.embeddedelasticsearch.InstallationDescription;
import pl.allegro.tech.embeddedelasticsearch.InstanceSettings;

class ElasticSearchInstaller {
    private static final Logger logger = LoggerFactory.getLogger(ElasticSearchInstaller.class);
    private static final String ELS_PACKAGE_PREFIX = "elasticsearch-";
    private final InstanceSettings instanceSettings;
    private final InstallationDescription installationDescription;
    private final ElasticDownloader elasticDownloader;

    ElasticSearchInstaller(InstanceSettings instanceSettings, InstallationDescription installationDescription) {
        this.instanceSettings = instanceSettings;
        this.installationDescription = installationDescription;
        this.elasticDownloader = new ElasticDownloader(installationDescription);
    }

    File getExecutableFile() {
        return this.fileRelativeToInstallationDir("bin", this.systemDependentExtension("elasticsearch"));
    }

    File getInstallationDirectory() {
        return FileUtils.getFile((File)this.installationDescription.getInstallationDirectory(), (String[])new String[]{ELS_PACKAGE_PREFIX + this.installationDescription.getVersion()});
    }

    void install() throws IOException, InterruptedException {
        Path downloadedTo = this.elasticDownloader.download();
        this.prepareDirectories();
        this.installElastic(downloadedTo);
        this.configureElastic();
        this.installPlugins();
    }

    private void prepareDirectories() throws IOException {
        FileUtils.forceMkdir((File)this.getInstallationDirectory());
    }

    private void installElastic(Path downloadedTo) throws IOException {
        File destination = this.getInstallationDirectory().getParentFile();
        FileUtils.forceDelete((File)this.getInstallationDirectory());
        logger.info("Installing Elasticsearch into " + destination + "...");
        try {
            this.unzip(downloadedTo, destination);
            logger.info("Done");
        }
        catch (IOException e) {
            logger.info("Failure : " + e);
            throw new EmbeddedElasticsearchStartupException(e);
        }
    }

    private void unzip(Path downloadedTo, File destination) throws IOException {
        Archiver archiver = ArchiverFactory.createArchiver((String)"zip");
        archiver.extract(downloadedTo.toFile(), destination);
    }

    private void configureElastic() throws IOException {
        File elasticsearchYml = FileUtils.getFile((File)this.getInstallationDirectory(), (String[])new String[]{"config", "elasticsearch.yml"});
        FileUtils.writeStringToFile((File)elasticsearchYml, (String)this.instanceSettings.toYaml(), (Charset)StandardCharsets.UTF_8);
    }

    private void installPlugins() throws IOException, InterruptedException {
        File pluginManager = this.pluginManagerExecutable();
        Set<String> alreadyInstalledPlugins = this.getAlreadyInstalledPlugins();
        for (InstallationDescription.Plugin plugin : this.installationDescription.getPlugins()) {
            if (ElasticSearchInstaller.isPluginInstalled(plugin, alreadyInstalledPlugins)) {
                logger.info("> Plugin " + plugin.getPluginName() + " already installed, skipping");
                continue;
            }
            this.installPlugin(pluginManager, plugin);
        }
    }

    private Set<String> getAlreadyInstalledPlugins() {
        File pluginsDir = new File(this.getInstallationDirectory(), "plugins");
        String[] pluginList = pluginsDir.list();
        if (pluginList != null) {
            return Stream.of(pluginList).collect(Collectors.toSet());
        }
        return Collections.emptySet();
    }

    private void installPlugin(File pluginManager, InstallationDescription.Plugin plugin) throws IOException, InterruptedException {
        String line;
        logger.info("> " + pluginManager + " install " + plugin.getExpression());
        ProcessBuilder builder = new ProcessBuilder(new String[0]);
        builder.redirectOutput(ProcessBuilder.Redirect.PIPE);
        builder.redirectErrorStream(true);
        builder.command(this.prepareInstallCommand(pluginManager, plugin));
        Process process = builder.start();
        BufferedReader bReader = new BufferedReader(new InputStreamReader(process.getInputStream(), StandardCharsets.UTF_8));
        while ((line = bReader.readLine()) != null) {
            logger.info(String.format("Plugin install %s: %s", plugin, line));
        }
        if (process.waitFor() != 0) {
            throw new EmbeddedElasticsearchStartupException("Unable to install plugin: " + plugin);
        }
    }

    private static boolean isPluginInstalled(InstallationDescription.Plugin plugin, Set<String> alreadyInstalledPlugins) {
        return alreadyInstalledPlugins.contains(plugin.getPluginName());
    }

    private String[] prepareInstallCommand(File pluginManager, InstallationDescription.Plugin plugin) {
        if (this.installationDescription.versionIs1x() && plugin.expressionIsUrl()) {
            return new String[]{pluginManager.getAbsolutePath(), "--install", plugin.getPluginName(), "--url", plugin.getExpression()};
        }
        if (this.installationDescription.versionIs1x() || this.installationDescription.versionIs2x()) {
            return new String[]{pluginManager.getAbsolutePath(), "install", plugin.getExpression()};
        }
        return new String[]{pluginManager.getAbsolutePath(), "install", "--batch", plugin.getExpression()};
    }

    private File pluginManagerExecutable() throws IOException {
        File elasticsearchPlugin = this.fileRelativeToInstallationDir("bin", this.systemDependentExtension("elasticsearch-plugin"));
        File pluginManager = elasticsearchPlugin.exists() ? elasticsearchPlugin : this.fileRelativeToInstallationDir("bin", this.systemDependentExtension("plugin"));
        return pluginManager;
    }

    private String systemDependentExtension(String baseFileName) {
        return baseFileName + (SystemUtils.IS_OS_WINDOWS ? ".bat" : "");
    }

    private File fileRelativeToInstallationDir(String ... path) {
        return FileUtils.getFile((File)this.getInstallationDirectory(), (String[])path);
    }
}

