/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.finance.tradukisto.internal.languages.turkish;

import com.google.common.base.Preconditions;
import java.math.BigDecimal;
import pl.allegro.finance.tradukisto.internal.BigDecimalToStringConverter;
import pl.allegro.finance.tradukisto.internal.IntegerToStringConverter;
import pl.allegro.finance.tradukisto.internal.languages.turkish.TurkishValues;

public class TurkishBigDecimalToBankingMoneyConverter
implements BigDecimalToStringConverter {
    private static final String SUBUNIT_SEPARATOR = ",";
    private static final String FORMAT = "%s%s%s%s";
    private static final int MAXIMAL_DECIMAL_PLACES_COUNT = 2;
    private final IntegerToStringConverter converter;
    private final TurkishValues turkishValues;

    public TurkishBigDecimalToBankingMoneyConverter(IntegerToStringConverter converter, TurkishValues turkishValues) {
        this.converter = converter;
        this.turkishValues = turkishValues;
    }

    @Override
    public String asWords(BigDecimal value) {
        return this.asWords(value, this.turkishValues.currency());
    }

    @Override
    public String asWords(BigDecimal value, String currencySymbol) {
        this.validate(value);
        Integer units = value.intValue();
        int subunits = value.remainder(BigDecimal.ONE).multiply(new BigDecimal(100)).intValue();
        String tempSubunitSymbol = this.turkishValues.subunitSymbol();
        String tempSubUnitWords = SUBUNIT_SEPARATOR + this.converter.asWords(subunits);
        if (subunits <= 0) {
            tempSubunitSymbol = "";
            tempSubUnitWords = "";
        }
        String formattedValue = String.format(FORMAT, this.converter.asWords(units), currencySymbol, tempSubUnitWords, tempSubunitSymbol);
        return formattedValue.replace(Character.toString(this.turkishValues.twoDigitsNumberSeparator()), "");
    }

    private void validate(BigDecimal value) {
        Preconditions.checkArgument((value.scale() <= 2 ? 1 : 0) != 0, (String)"can't transform more than %s decimal places for value %s", (int)2, (Object)value);
        Preconditions.checkArgument((boolean)this.valueLessThanIntMax(value), (String)"can't transform numbers greater than Integer.MAX_VALUE for value %s", (Object)value);
        Preconditions.checkArgument((boolean)this.valueGreaterThanOrEqualToZero(value), (String)"can't transform negative numbers for value %s", (Object)value);
    }

    private boolean valueLessThanIntMax(BigDecimal value) {
        return value.compareTo(new BigDecimal(Integer.MAX_VALUE).add(BigDecimal.ONE)) == -1;
    }

    private boolean valueGreaterThanOrEqualToZero(BigDecimal value) {
        return value.signum() >= 0;
    }
}

