/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.finance.tradukisto.internal.languages.italian;

import java.util.Map;
import pl.allegro.finance.tradukisto.internal.GenderAwareIntegerToStringConverter;
import pl.allegro.finance.tradukisto.internal.IntegerToStringConverter;
import pl.allegro.finance.tradukisto.internal.NumberProcessor;

public class ItalianIntegerToWordsConverter
implements IntegerToStringConverter {
    private final IntegerToStringConverter bigNumbersConverter;
    private final Map<Integer, String> exceptions;
    private final GenderAwareIntegerToStringConverter smallNumbersConverter;

    public ItalianIntegerToWordsConverter(IntegerToStringConverter bigNumbersConverter, Map<Integer, String> exceptions, GenderAwareIntegerToStringConverter smallNumbersConverter) {
        this.bigNumbersConverter = bigNumbersConverter;
        this.exceptions = exceptions;
        this.smallNumbersConverter = smallNumbersConverter;
    }

    @Override
    public String asWords(Integer value) {
        if (this.exceptions.containsKey(value)) {
            return this.exceptions.get(value);
        }
        Integer bigNumber = value / 1000000;
        Integer smallNumber = value % 1000000;
        return new NumberProcessor(this.bigNumbersConverter, this.smallNumbersConverter).process(bigNumber, smallNumber).replace(" ", "");
    }
}

