/*
 * Decompiled with CFR 0.152.
 */
package party.iroiro.luajava.jsr223;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineFactory;
import party.iroiro.luajava.jsr223.LuaScriptEngine;
import party.iroiro.luajava.util.ClassUtils;

public class LuaScriptEngineFactory
implements ScriptEngineFactory {
    private static final List<String> MIME_TYPES;
    private static final List<String> EXTENSIONS;
    private final String name;
    private final String version;
    private final List<String> names;
    private final String luaClass;
    private static final char[] HEX_LOOKUP;
    private static final String[][] ENGINES;

    public LuaScriptEngineFactory() {
        this(LuaScriptEngineFactory.findAvailableEngine());
    }

    protected LuaScriptEngineFactory(String[] engine) {
        this(engine[0], engine[1], engine[2]);
    }

    public LuaScriptEngineFactory(String name, String version, String luaClass) {
        this.name = name;
        this.version = version;
        this.luaClass = luaClass;
        this.names = Collections.singletonList(name.toLowerCase().replace(" ", "").replace(".", ""));
    }

    @Override
    public String getEngineName() {
        return this.name;
    }

    @Override
    public String getEngineVersion() {
        return this.version;
    }

    @Override
    public List<String> getExtensions() {
        return EXTENSIONS;
    }

    @Override
    public List<String> getMimeTypes() {
        return MIME_TYPES;
    }

    @Override
    public List<String> getNames() {
        return this.names;
    }

    @Override
    public String getLanguageName() {
        return "Lua";
    }

    @Override
    public String getLanguageVersion() {
        return this.version;
    }

    @Override
    public Object getParameter(String s) {
        switch (s) {
            case "ENGINE": {
                return this.getEngineName();
            }
            case "ENGINE_VERSION": {
                return this.getEngineVersion();
            }
            case "LANGUAGE": {
                return this.getLanguageName();
            }
            case "LANGUAGE_VERSION": {
                return this.getLanguageVersion();
            }
            case "NAME": {
                return this.getNames().get(0);
            }
            case "THREADING": {
                return "THREAD-ISOLATED";
            }
        }
        return null;
    }

    @Override
    public String getMethodCallSyntax(String obj, String m, String ... args) {
        return obj + ":" + m + "(" + String.join((CharSequence)", ", args) + ")";
    }

    @Override
    public String getOutputStatement(String s) {
        return LuaScriptEngineFactory.escape(s, "print(\"", "\")");
    }

    @Override
    public String getProgram(String ... strings) {
        int length = strings.length * 2;
        for (String string : strings) {
            length += string.length();
        }
        StringBuilder builder = new StringBuilder(length);
        for (String string : strings) {
            builder.append(string).append(";\n");
        }
        return builder.toString();
    }

    @Override
    public ScriptEngine getScriptEngine() {
        return new LuaScriptEngine(this.luaClass, this);
    }

    private static String escape(String s, String prefix, String suffix) {
        byte[] bytes = s.getBytes(StandardCharsets.UTF_8);
        StringBuilder builder = new StringBuilder(bytes.length * 4 + prefix.length() + suffix.length());
        builder.append(prefix);
        for (byte b : bytes) {
            builder.append("\\x");
            builder.append(HEX_LOOKUP[b >> 4]);
            builder.append(HEX_LOOKUP[b & 0xF]);
        }
        builder.append(suffix);
        return builder.toString();
    }

    private static String[] findAvailableEngine() {
        String wanted = System.getProperty("luajava.jsr-223");
        if (wanted != null) {
            for (String[] engine : ENGINES) {
                if (!engine[3].equals(wanted) && !("lua" + engine[3]).equals(wanted)) continue;
                return engine;
            }
        }
        for (String[] engine : ENGINES) {
            try {
                ClassUtils.forName((String)engine[2]);
                return engine;
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
        }
        throw new LinkageError("No available Lua provider found");
    }

    static {
        ArrayList<String> mimeTypes = new ArrayList<String>(2);
        mimeTypes.add("text/x-lua");
        mimeTypes.add("application/x-lua");
        MIME_TYPES = Collections.unmodifiableList(mimeTypes);
        EXTENSIONS = Collections.singletonList("lua");
        HEX_LOOKUP = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
        ENGINES = new String[][]{{"Lua 5.4", "5.4.4", "party.iroiro.luajava.lua54.Lua54", "54"}, {"Lua 5.3", "5.3.6", "party.iroiro.luajava.lua53.Lua53", "53"}, {"Lua 5.2", "5.2.4", "party.iroiro.luajava.lua52.Lua52", "52"}, {"LuaJ", "5.2.4", "party.iroiro.luajava.luaj.LuaJ", "j"}, {"LuaJIT", "6c4826f12c4d33b8b978004bc681eb1eef2be977", "party.iroiro.luajava.luajit.LuaJit", "jit"}, {"Lua 5.1", "5.1.5", "party.iroiro.luajava.lua51.Lua51", "51"}};
    }
}

