/*
 * Decompiled with CFR 0.152.
 */
package zmq.io.coder;

import zmq.Msg;
import zmq.io.coder.DecoderBase;
import zmq.io.coder.IDecoder;
import zmq.msg.MsgAllocator;
import zmq.util.Errno;

public abstract class Decoder
extends DecoderBase {
    protected final long maxmsgsize;
    protected Msg inProgress;
    protected final IDecoder.Step oneByteSizeReady = new OneByteSizeReady();
    protected final IDecoder.Step eightByteSizeReady = new EightByteSizeReady();
    protected final IDecoder.Step flagsReady = new FlagsReady();
    protected final IDecoder.Step messageReady = new MessageReady();
    private final MsgAllocator allocator;

    public Decoder(Errno errno, int bufsize, long maxmsgsize, MsgAllocator allocator) {
        super(errno, bufsize);
        this.maxmsgsize = maxmsgsize;
        this.allocator = allocator;
    }

    protected final IDecoder.Step.Result sizeReady(long size) {
        if (this.maxmsgsize >= 0L && size > this.maxmsgsize) {
            this.errno(156384722);
            return IDecoder.Step.Result.ERROR;
        }
        if (size > Integer.MAX_VALUE) {
            this.errno(156384722);
            return IDecoder.Step.Result.ERROR;
        }
        this.inProgress = this.allocate((int)size);
        return IDecoder.Step.Result.MORE_DATA;
    }

    protected Msg allocate(int size) {
        return this.allocator.allocate(size);
    }

    protected IDecoder.Step.Result oneByteSizeReady() {
        throw new UnsupportedOperationException("Have you forgot to implement oneByteSizeReady ?");
    }

    protected IDecoder.Step.Result eightByteSizeReady() {
        throw new UnsupportedOperationException("Have you forgot to implement eightByteSizeReady ?");
    }

    protected IDecoder.Step.Result flagsReady() {
        throw new UnsupportedOperationException("Have you forgot to implement flagsReady ?");
    }

    protected IDecoder.Step.Result messageReady() {
        throw new UnsupportedOperationException("Have you forgot to implement messageReady ?");
    }

    protected IDecoder.Step.Result messageIncomplete() {
        return IDecoder.Step.Result.MORE_DATA;
    }

    @Override
    public Msg msg() {
        return this.inProgress;
    }

    private final class OneByteSizeReady
    implements IDecoder.Step {
        private OneByteSizeReady() {
        }

        @Override
        public IDecoder.Step.Result apply() {
            return Decoder.this.oneByteSizeReady();
        }
    }

    private final class EightByteSizeReady
    implements IDecoder.Step {
        private EightByteSizeReady() {
        }

        @Override
        public IDecoder.Step.Result apply() {
            return Decoder.this.eightByteSizeReady();
        }
    }

    private final class FlagsReady
    implements IDecoder.Step {
        private FlagsReady() {
        }

        @Override
        public IDecoder.Step.Result apply() {
            return Decoder.this.flagsReady();
        }
    }

    private final class MessageReady
    implements IDecoder.Step {
        private MessageReady() {
        }

        @Override
        public IDecoder.Step.Result apply() {
            return Decoder.this.messageReady();
        }
    }
}

