/*
 * Decompiled with CFR 0.152.
 */
package zmq.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class MultiMap<K extends Comparable<? super K>, V> {
    private final Comparator<? super Map.Entry<V, K>> comparator = new EntryComparator();
    private final Map<K, List<V>> data = new HashMap<K, List<V>>();
    private final Map<V, K> inverse = new HashMap<V, K>();

    public void clear() {
        this.data.clear();
        this.inverse.clear();
    }

    public Collection<Map.Entry<V, K>> entries() {
        ArrayList<Map.Entry<V, K>> list = new ArrayList<Map.Entry<V, K>>(this.inverse.entrySet());
        Collections.sort(list, this.comparator);
        return list;
    }

    public Collection<V> values() {
        return this.inverse.keySet();
    }

    public V find(V copy) {
        Comparable key = (Comparable)this.inverse.get(copy);
        if (key != null) {
            List<V> list = this.data.get(key);
            return list.get(list.indexOf(copy));
        }
        return null;
    }

    public boolean hasValues(K key) {
        List<V> list = this.data.get(key);
        if (list == null) {
            return false;
        }
        return !list.isEmpty();
    }

    public boolean isEmpty() {
        return this.inverse.isEmpty();
    }

    private List<V> getValues(K key) {
        List<V> list = this.data.get(key);
        if (list == null) {
            list = new ArrayList<V>();
            this.data.put(key, list);
        }
        return list;
    }

    public boolean insert(K key, V value) {
        boolean inserted;
        Comparable old = (Comparable)this.inverse.get(value);
        if (old != null) {
            this.getValues(old).remove(value);
        }
        if (inserted = this.getValues(key).add(value)) {
            this.inverse.put(value, key);
        }
        return inserted;
    }

    public Collection<V> remove(K key) {
        List<V> removed = this.data.remove(key);
        if (removed != null) {
            for (V val : removed) {
                this.inverse.remove(val);
            }
        }
        return removed;
    }

    public boolean remove(V value) {
        Comparable key = (Comparable)this.inverse.remove(value);
        if (key != null) {
            return this.getValues(key).remove(value);
        }
        return false;
    }

    public boolean remove(Map.Entry<V, K> entry) {
        Comparable key = (Comparable)entry.getValue();
        V value = entry.getKey();
        boolean removed = this.getValues(key).remove(value);
        if (removed) {
            this.inverse.remove(value);
        }
        return removed;
    }

    public String toString() {
        return this.data.toString();
    }

    private final class EntryComparator
    implements Comparator<Map.Entry<V, K>> {
        private EntryComparator() {
        }

        @Override
        public int compare(Map.Entry<V, K> first, Map.Entry<V, K> second) {
            return ((Comparable)first.getValue()).compareTo(second.getValue());
        }
    }
}

