/*
 * Decompiled with CFR 0.152.
 */
package org.zeromq;

import java.io.Closeable;
import java.io.IOException;
import java.nio.channels.SelectableChannel;
import java.nio.channels.Selector;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.zeromq.ZContext;
import org.zeromq.ZMQ;
import zmq.ZMQ;
import zmq.poll.PollItem;

public class ZPoller
implements Closeable {
    public static final int POLLIN = 1;
    public static final int POLLOUT = 2;
    public static final int POLLERR = 4;
    public static final int IN = 1;
    public static final int OUT = 2;
    public static final int ERR = 4;
    public static final int READABLE = 1;
    public static final int WRITABLE = 2;
    private final Selector selector;
    private final ItemCreator creator;
    private final Map<Object, Set<ItemHolder>> items;
    private final Set<ItemHolder> all;
    private EventsHandler globalHandler;

    public ZPoller(ZPoller poller) {
        this(poller.creator, poller.selector);
    }

    public ZPoller(Selector selector) {
        this((ItemCreator)new SimpleCreator(), selector);
    }

    public ZPoller(ZContext context) {
        this((ItemCreator)new SimpleCreator(), context.createSelector());
    }

    public ZPoller(ItemCreator creator, ZPoller poller) {
        this(creator, poller.selector);
    }

    public ZPoller(ItemCreator creator, ZContext context) {
        this(creator, context.createSelector());
    }

    public ZPoller(ItemCreator creator, Selector selector) {
        this.creator = creator;
        this.selector = selector;
        this.items = new HashMap<Object, Set<ItemHolder>>();
        this.all = this.createContainer(0);
    }

    protected ItemHolder create(ZMQ.Socket socket, EventsHandler handler, int events) {
        assert (socket != null);
        return this.creator.create(socket, handler, events);
    }

    protected ItemHolder create(SelectableChannel channel, EventsHandler handler, int events) {
        assert (channel != null);
        return this.creator.create(channel, handler, events);
    }

    public void setGlobalHandler(EventsHandler globalHandler) {
        this.globalHandler = globalHandler;
    }

    public EventsHandler getGlobalHandler() {
        return this.globalHandler;
    }

    public final boolean register(ZMQ.Socket socket, EventsHandler handler, int events) {
        if (socket == null) {
            return false;
        }
        return this.add(socket, this.create(socket, handler, events));
    }

    public final boolean register(ZMQ.Socket socket, EventsHandler handler) {
        return this.register(socket, handler, 7);
    }

    public final boolean register(ZMQ.Socket socket, int events) {
        return this.register(socket, this.globalHandler, events);
    }

    public final boolean register(SelectableChannel channel, EventsHandler handler, int events) {
        if (channel == null) {
            return false;
        }
        return this.add(channel, this.create(channel, handler, events));
    }

    public final boolean register(SelectableChannel channel, EventsHandler handler) {
        return this.register(channel, handler, 7);
    }

    public final boolean register(SelectableChannel channel, int events) {
        return this.register(channel, this.globalHandler, events);
    }

    public final boolean register(ItemHolder item) {
        return this.add(null, item);
    }

    public final boolean unregister(Object socketOrChannel) {
        boolean rc;
        if (socketOrChannel == null) {
            return false;
        }
        Set<ItemHolder> items = this.items.remove(socketOrChannel);
        boolean bl = rc = items != null;
        if (rc) {
            this.all.removeAll(items);
        }
        return rc;
    }

    public int poll(long timeout) {
        return this.poll(timeout, true);
    }

    protected int poll(long timeout, boolean dispatchEvents) {
        Collection<ItemHolder> all = this.items();
        HashSet<PollItem> pollItems = new HashSet<PollItem>(all.size());
        for (ItemHolder holder : all) {
            pollItems.add(holder.item());
        }
        int rc = this.poll(this.selector, timeout, pollItems);
        if (!dispatchEvents) {
            return rc;
        }
        if (this.dispatch(all, pollItems.size())) {
            return rc;
        }
        return -1;
    }

    protected int poll(Selector selector, long tout, Collection<PollItem> items) {
        int size = items.size();
        return ZMQ.poll(selector, items.toArray(new PollItem[size]), size, tout);
    }

    protected boolean dispatch(Collection<ItemHolder> all, int size) {
        ItemHolder[] array;
        for (ItemHolder holder : array = all.toArray(new ItemHolder[all.size()])) {
            PollItem item;
            int events;
            EventsHandler handler = holder.handler();
            if (handler == null) {
                handler = this.globalHandler;
            }
            if (handler == null || (events = (item = holder.item()).readyOps()) <= 0) continue;
            ZMQ.Socket socket = holder.socket();
            SelectableChannel channel = holder.item().getRawSocket();
            if (socket != null) {
                assert (channel == null);
                if (!handler.events(socket, events)) {
                    return false;
                }
            }
            if (channel == null) continue;
            assert (socket == null);
            if (handler.events(channel, events)) continue;
            return false;
        }
        return true;
    }

    public boolean dispatch() {
        return this.dispatch(this.all, this.all.size());
    }

    public boolean isReadable(SelectableChannel channel) {
        return this.readable((Object)channel);
    }

    public boolean readable(SelectableChannel channel) {
        return this.readable((Object)channel);
    }

    public boolean isReadable(ZMQ.Socket socket) {
        return this.readable(socket);
    }

    public boolean readable(ZMQ.Socket socket) {
        return this.readable((Object)socket);
    }

    public boolean readable(Object socketOrChannel) {
        PollItem it = this.filter(socketOrChannel, 1);
        if (it == null) {
            return false;
        }
        return it.isReadable();
    }

    public boolean pollin(ZMQ.Socket socket) {
        return this.isReadable(socket);
    }

    public boolean pollin(SelectableChannel channel) {
        return this.isReadable(channel);
    }

    public boolean isWritable(SelectableChannel channel) {
        return this.writable((Object)channel);
    }

    public boolean writable(SelectableChannel channel) {
        return this.writable((Object)channel);
    }

    public boolean isWritable(ZMQ.Socket socket) {
        return this.writable((Object)socket);
    }

    public boolean writable(ZMQ.Socket socket) {
        return this.writable((Object)socket);
    }

    public boolean writable(Object socketOrChannel) {
        PollItem it = this.filter(socketOrChannel, 2);
        if (it == null) {
            return false;
        }
        return it.isWritable();
    }

    public boolean pollout(ZMQ.Socket socket) {
        return this.isWritable(socket);
    }

    public boolean pollout(SelectableChannel channel) {
        return this.isWritable(channel);
    }

    public boolean isError(SelectableChannel channel) {
        return this.error((Object)channel);
    }

    public boolean error(SelectableChannel channel) {
        return this.error((Object)channel);
    }

    public boolean isError(ZMQ.Socket socket) {
        return this.error((Object)socket);
    }

    public boolean error(ZMQ.Socket socket) {
        return this.error((Object)socket);
    }

    public boolean error(Object socketOrChannel) {
        PollItem it = this.filter(socketOrChannel, 4);
        if (it == null) {
            return false;
        }
        return it.isError();
    }

    public boolean pollerr(ZMQ.Socket socket) {
        return this.isError(socket);
    }

    public boolean pollerr(SelectableChannel channel) {
        return this.isError(channel);
    }

    @Override
    public void close() throws IOException {
    }

    public void destroy() {
        try {
            this.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    protected boolean add(Object socketOrChannel, ItemHolder holder) {
        boolean rc;
        if (socketOrChannel == null) {
            ZMQ.Socket socket = holder.socket();
            SelectableChannel ch = holder.item().getRawSocket();
            if (socket == null) {
                assert (ch != null);
                socketOrChannel = ch;
            }
            if (ch == null) {
                assert (socket != null);
                socketOrChannel = socket;
            }
        }
        assert (socketOrChannel != null);
        Set<ItemHolder> holders = this.items.get(socketOrChannel);
        if (holders == null) {
            holders = this.createContainer(1);
            this.items.put(socketOrChannel, holders);
        }
        if (rc = holders.add(holder)) {
            this.all.add(holder);
        }
        return rc;
    }

    protected Set<ItemHolder> createContainer(int size) {
        return new HashSet<ItemHolder>(size);
    }

    protected Collection<ItemHolder> items() {
        return this.all;
    }

    protected Iterable<ItemHolder> items(Object socketOrChannel) {
        Set<ItemHolder> set = this.items.get(socketOrChannel);
        if (set == null) {
            return Collections.emptySet();
        }
        return set;
    }

    protected PollItem filter(Object socketOrChannel, int events) {
        if (socketOrChannel == null) {
            return null;
        }
        Iterable<ItemHolder> items = this.items(socketOrChannel);
        for (ItemHolder item : items) {
            PollItem it = item.item();
            if ((it.zinterestOps() & events) <= 0) continue;
            return it;
        }
        return null;
    }

    private static class SimpleCreator
    implements ItemCreator {
        private SimpleCreator() {
        }

        @Override
        public ItemHolder create(ZMQ.Socket socket, EventsHandler handler, int events) {
            return new ZPollItem(socket, handler, events);
        }

        @Override
        public ItemHolder create(SelectableChannel channel, EventsHandler handler, int events) {
            return new ZPollItem(channel, handler, events);
        }
    }

    public static class ZPollItem
    extends ZMQ.PollItem
    implements ItemHolder {
        private final EventsHandler handler;

        public ZPollItem(ZMQ.Socket socket, EventsHandler handler, int ops) {
            super(socket, ops);
            this.handler = handler;
        }

        public ZPollItem(SelectableChannel channel, EventsHandler handler, int ops) {
            super(channel, ops);
            this.handler = handler;
        }

        @Override
        public PollItem item() {
            return this.base();
        }

        @Override
        public ZMQ.Socket socket() {
            return this.getSocket();
        }

        @Override
        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.item() == null ? 0 : this.item().hashCode());
            result = 31 * result + (this.getRawSocket() == null ? 0 : this.getRawSocket().hashCode());
            result = 31 * result + (this.socket() == null ? 0 : this.socket().hashCode());
            result = 31 * result + (this.handler() == null ? 0 : this.handler().hashCode());
            return result;
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof ItemHolder)) {
                return false;
            }
            ItemHolder other = (ItemHolder)obj;
            if (this.item() == null ? other.item() != null : !this.item().equals(other.item())) {
                return false;
            }
            if (this.item().getRawSocket() == null ? other.item().getRawSocket() != null : !this.item().getRawSocket().equals(other.item().getRawSocket())) {
                return false;
            }
            if (this.socket() == null ? other.socket() != null : !this.socket().equals(other.socket())) {
                return false;
            }
            return !(this.handler() == null ? other.handler() != null : !this.handler().equals(other.handler()));
        }

        @Override
        public EventsHandler handler() {
            return this.handler;
        }
    }

    public static interface ItemCreator {
        public ItemHolder create(ZMQ.Socket var1, EventsHandler var2, int var3);

        public ItemHolder create(SelectableChannel var1, EventsHandler var2, int var3);
    }

    public static interface ItemHolder {
        public PollItem item();

        public ZMQ.Socket socket();

        public EventsHandler handler();
    }

    public static interface EventsHandler {
        public boolean events(ZMQ.Socket var1, int var2);

        public boolean events(SelectableChannel var1, int var2);
    }
}

