/*
 * Decompiled with CFR 0.152.
 */
package org.zeromq;

import java.io.Closeable;
import java.nio.channels.Selector;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.zeromq.ZMQ;

public class ZContext
implements Closeable {
    private volatile ZMQ.Context context;
    private final List<ZMQ.Socket> sockets = new CopyOnWriteArrayList<ZMQ.Socket>();
    private final int ioThreads;
    private int linger;
    private final boolean main;

    public ZContext() {
        this(1);
    }

    public ZContext(int ioThreads) {
        this(null, true, ioThreads);
    }

    private ZContext(ZMQ.Context context, boolean main, int ioThreads) {
        this.context = context;
        this.ioThreads = ioThreads;
        this.main = main;
        this.linger = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        for (ZMQ.Socket socket : this.sockets) {
            socket.setLinger(this.linger);
            socket.close();
        }
        this.sockets.clear();
        if (this.isMain() && this.context != null) {
            this.context.term();
        }
        ZContext zContext = this;
        synchronized (zContext) {
            this.context = null;
        }
    }

    public ZMQ.Socket createSocket(int type) {
        ZMQ.Socket socket = this.getContext().socket(type);
        this.sockets.add(socket);
        return socket;
    }

    public void destroySocket(ZMQ.Socket s) {
        if (s == null) {
            return;
        }
        if (this.sockets.remove(s)) {
            s.setLinger(this.linger);
            s.close();
        }
    }

    public Selector createSelector() {
        return this.getContext().selector();
    }

    public ZMQ.Poller createPoller(int size) {
        return new ZMQ.Poller(this.getContext(), size);
    }

    public static ZContext shadow(ZContext ctx) {
        return new ZContext(ctx.getContext(), false, ctx.getIoThreads());
    }

    public int getIoThreads() {
        return this.ioThreads;
    }

    @Deprecated
    public void setIoThreads(int ioThreads) {
    }

    public int getLinger() {
        return this.linger;
    }

    public void setLinger(int linger) {
        this.linger = linger;
    }

    public boolean isMain() {
        return this.main;
    }

    @Deprecated
    public void setMain(boolean main) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ZMQ.Context getContext() {
        ZMQ.Context result = this.context;
        if (result == null) {
            ZContext zContext = this;
            synchronized (zContext) {
                result = this.context;
                if (result == null) {
                    this.context = result = ZMQ.context(this.ioThreads);
                }
            }
        }
        return result;
    }

    @Deprecated
    public void setContext(ZMQ.Context ctx) {
    }

    public List<ZMQ.Socket> getSockets() {
        return this.sockets;
    }

    @Override
    public void close() {
        this.destroy();
    }
}

