/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.logbook.json;

import com.fasterxml.jackson.annotation.JsonRawValue;
import com.fasterxml.jackson.annotation.JsonValue;
import java.io.IOException;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.apiguardian.api.API;
import org.zalando.logbook.ContentType;
import org.zalando.logbook.HttpMessage;
import org.zalando.logbook.StructuredHttpLogFormatter;
import tools.jackson.databind.json.JsonMapper;

@API(status=API.Status.STABLE)
@Generated
public final class JsonHttpLogFormatter
implements StructuredHttpLogFormatter {
    private final JsonMapper mapper;

    public JsonHttpLogFormatter() {
        this(new JsonMapper());
    }

    public JsonHttpLogFormatter(JsonMapper mapper) {
        this.mapper = mapper;
    }

    public Optional<Object> prepareBody(HttpMessage message) throws IOException {
        String contentType = message.getContentType();
        String body = message.getBodyAsString();
        if (body.isEmpty()) {
            return Optional.empty();
        }
        if (ContentType.isJsonMediaType((String)contentType)) {
            return Optional.of(new JsonBody(body));
        }
        return Optional.of(body);
    }

    public String format(Map<String, Object> content) throws IOException {
        return this.mapper.writeValueAsString(content);
    }

    @Generated
    private static final class JsonBody {
        String json;

        @JsonRawValue
        @JsonValue
        public String getJson() {
            return this.json;
        }

        @Generated
        public JsonBody(String json) {
            this.json = json;
        }
    }
}

