/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.logbook.json;

import com.fasterxml.jackson.core.JsonGenerator;
import java.io.IOException;
import org.apiguardian.api.API;
import org.zalando.logbook.Correlation;
import org.zalando.logbook.HttpMessage;
import org.zalando.logbook.HttpRequest;
import org.zalando.logbook.HttpResponse;
import org.zalando.logbook.Origin;
import org.zalando.logbook.Precorrelation;

public interface JsonFieldWriterJackson2 {
    public <M extends HttpMessage> void write(M var1, JsonGenerator var2) throws IOException;

    @API(status=API.Status.EXPERIMENTAL)
    default public void write(Precorrelation correlation, HttpRequest request, JsonGenerator generator) throws IOException {
        generator.writeStringField("origin", JsonFieldWriterJackson2.getOrigin((HttpMessage)request));
        generator.writeStringField("type", "request");
        generator.writeStringField("correlation", correlation.getId());
        generator.writeStringField("protocol", request.getProtocolVersion());
        generator.writeStringField("remote", request.getRemote());
        generator.writeStringField("method", request.getMethod());
        generator.writeStringField("uri", request.getRequestUri());
    }

    @API(status=API.Status.EXPERIMENTAL)
    default public void write(Correlation correlation, HttpResponse response, JsonGenerator generator) throws IOException {
        generator.writeStringField("origin", JsonFieldWriterJackson2.getOrigin((HttpMessage)response));
        generator.writeStringField("type", "response");
        generator.writeStringField("correlation", correlation.getId());
        generator.writeStringField("protocol", response.getProtocolVersion());
        generator.writeNumberField("duration", correlation.getDuration().toMillis());
        generator.writeNumberField("status", response.getStatus());
    }

    public static String getOrigin(HttpMessage message) {
        return message.getOrigin() == Origin.LOCAL ? "local" : "remote";
    }
}

