/*
******************************************************************
Copyright (c) 2001-2007,2015 Jeff Martin, Tim Bacon
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions
are met:

    * Redistributions of source code must retain the above copyright
      notice, this list of conditions and the following disclaimer.
    * Redistributions in binary form must reproduce the above
      copyright notice, this list of conditions and the following
      disclaimer in the documentation and/or other materials provided
      with the distribution.
    * Neither the name of the XMLUnit nor the names
      of its contributors may be used to endorse or promote products
      derived from this software without specific prior written
      permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
"AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN
ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
POSSIBILITY OF SUCH DAMAGE.

******************************************************************
*/

package org.custommonkey.xmlunit;

import org.w3c.dom.Node;

/**
 * Thrown by a NodeTest that fails.
 * @see NodeTest
 */
public class NodeTestException extends Exception {
    private transient final Node node;

    /**
     * Constructor for specific node and message
     * @param message
     * @param node
     */
    public NodeTestException(String message, Node node) {
        super(message);
        this.node = node;
    }

    /**
     * Constructor for message only
     * @param message
     */
    public NodeTestException(String message) {
        this(message, null);
    }

    /**
     * @return true if a node was passed to constructor
     */
    public boolean hasNode() {
        return node != null;
    }

    /**
     * @return the node passed to constructor, or null if no node was passed
     */
    public Node getNode() {
        return node;
    }

    /**
     * @return the exception message and node information if available
     */
    public String getMessage() {
        StringBuilder stringBuilder = new StringBuilder(super.getMessage());
        if (hasNode()) {
            stringBuilder.append(' ')
                .append(getNode().toString());
        }
        return stringBuilder.toString();
    }
}
