/*
 * Decompiled with CFR 0.152.
 */
package xerial.larray.buffer;

import java.lang.ref.ReferenceQueue;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import java.util.logging.Logger;
import xerial.larray.buffer.Memory;
import xerial.larray.buffer.MemoryAllocator;
import xerial.larray.buffer.MemoryReference;
import xerial.larray.buffer.OffHeapMemory;
import xerial.larray.buffer.UnsafeUtil;

public class DefaultMemoryAllocator
implements MemoryAllocator {
    private static Logger logger = Logger.getLogger(DefaultMemoryAllocator.class.getName());
    private Map<Long, MemoryReference> allocatedMemoryReferences = new ConcurrentHashMap<Long, MemoryReference>();
    private ReferenceQueue<Memory> queue = new ReferenceQueue();
    private AtomicLong totalAllocatedSize;

    public DefaultMemoryAllocator() {
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                while (true) {
                    try {
                        while (true) {
                            MemoryReference memoryReference = (MemoryReference)MemoryReference.class.cast(DefaultMemoryAllocator.this.queue.remove());
                            if (logger.isLoggable(Level.FINER)) {
                                logger.finer(String.format("Found GC target at %x", memoryReference.address));
                            }
                            DefaultMemoryAllocator.this.release(memoryReference);
                        }
                    }
                    catch (Exception exception) {
                        exception.printStackTrace(System.err);
                        continue;
                    }
                    break;
                }
            }
        });
        thread.setName("LArray-GC");
        thread.setDaemon(true);
        logger.finer("Start memory collector");
        thread.start();
        this.totalAllocatedSize = new AtomicLong(0L);
    }

    @Override
    public long allocatedSize() {
        return this.totalAllocatedSize.get();
    }

    @Override
    public Memory allocate(long l) {
        if (l == 0L) {
            return new OffHeapMemory();
        }
        long l2 = l + OffHeapMemory.HEADER_SIZE;
        long l3 = UnsafeUtil.unsafe.allocateMemory(l2);
        OffHeapMemory offHeapMemory = new OffHeapMemory(l3, l);
        this.register(offHeapMemory);
        return offHeapMemory;
    }

    @Override
    public void register(Memory memory) {
        MemoryReference memoryReference = memory.toRef(this.queue);
        this.allocatedMemoryReferences.put(memoryReference.address, memoryReference);
        this.totalAllocatedSize.getAndAdd(memory.size());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseAll() {
        DefaultMemoryAllocator defaultMemoryAllocator = this;
        synchronized (defaultMemoryAllocator) {
            Object[] objectArray = this.allocatedMemoryReferences.values().toArray();
            if (objectArray.length != 0) {
                logger.finer("Releasing allocated memory regions");
            }
            for (Object object : objectArray) {
                this.release((MemoryReference)object);
            }
        }
    }

    @Override
    public void release(MemoryReference memoryReference) {
        this.release(memoryReference.toMemory());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void release(Memory memory) {
        DefaultMemoryAllocator defaultMemoryAllocator = this;
        synchronized (defaultMemoryAllocator) {
            long l = memory.headerAddress();
            if (this.allocatedMemoryReferences.containsKey(l)) {
                if (logger.isLoggable(Level.FINER)) {
                    logger.finer(String.format("Released memory at %x (size:%,d)", l, memory.dataSize()));
                }
                this.totalAllocatedSize.getAndAdd(-memory.size());
                this.allocatedMemoryReferences.remove(l);
                memory.release();
            }
        }
    }
}

