/*
 * Decompiled with CFR 0.152.
 */
package org.xenei.junit.contract.info;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.xenei.junit.contract.Contract;
import org.xenei.junit.contract.ContractImpl;
import org.xenei.junit.contract.MethodUtils;
import org.xenei.junit.contract.info.DynamicSuiteInfo;
import org.xenei.junit.contract.info.TestInfo;

public class DynamicTestInfo
extends TestInfo {
    private final Method dynamicInjector;
    private final Method getter;

    public DynamicTestInfo(Class<?> cls, ContractImpl impl, DynamicSuiteInfo suite) {
        super(cls, impl, MethodUtils.findAnnotatedSetter(cls, Contract.Inject.class));
        if (this.getMethod() == null) {
            throw new IllegalStateException("Dynamic tests annotated with @RunWith(ContractSuite.class) (" + this.getTestClass() + ") must include a @Contract.Inject annotation on a concrete declared setter method");
        }
        this.getter = MethodUtils.findAnnotatedGetter(cls, Contract.Inject.class);
        if (this.getter == null) {
            throw new IllegalStateException("Dynamic tests annotated with @RunWith(ContractSuite.class) (" + this.getTestClass() + ") must include a @Contract.Inject annotation on a concrete declared getter method");
        }
        this.dynamicInjector = suite.getDynamicInjector();
    }

    public Method getDynamicInjector() {
        return this.dynamicInjector;
    }

    public Object getProducer(Object baseProducer) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException, InstantiationException {
        Object suiteTest = this.getTestClass().newInstance();
        this.getMethod().invoke(suiteTest, baseProducer);
        return this.getter.invoke(suiteTest, new Object[0]);
    }
}

