/*
 * Decompiled with CFR 0.152.
 */
package org.xenei.junit.contract;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.junit.After;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.runner.Description;
import org.junit.runner.RunWith;
import org.junit.runner.Runner;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.BlockJUnit4ClassRunner;
import org.junit.runners.ParentRunner;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.InitializationError;
import org.junit.runners.model.RunnerBuilder;
import org.junit.runners.model.Statement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xenei.junit.contract.ClassPathUtils;
import org.xenei.junit.contract.Contract;
import org.xenei.junit.contract.ContractImpl;
import org.xenei.junit.contract.ContractTest;
import org.xenei.junit.contract.ContractTestRunner;
import org.xenei.junit.contract.Dynamic;
import org.xenei.junit.contract.info.DynamicSuiteInfo;
import org.xenei.junit.contract.info.DynamicTestInfo;
import org.xenei.junit.contract.info.SuiteInfo;
import org.xenei.junit.contract.info.TestInfo;

@Ignore(value="Not a real test")
public class ContractSuite
extends ParentRunner<Runner> {
    private static final Logger LOG = LoggerFactory.getLogger(ContractSuite.class);
    private final List<Runner> fRunners;

    public ContractSuite(Class<?> cls, RunnerBuilder builder) throws Throwable {
        super(cls);
        ArrayList<Throwable> errors = new ArrayList<Throwable>();
        ContractTestMap contractTestMap = ContractSuite.populateAnnotatedClassContainers(errors);
        Object baseObj = cls.newInstance();
        List<Runner> r = baseObj instanceof Dynamic ? this.addDynamicClasses(builder, errors, contractTestMap, (Dynamic)baseObj) : this.addAnnotatedClasses(cls, builder, errors, contractTestMap, baseObj);
        if (!errors.isEmpty()) {
            throw new InitializationError(errors);
        }
        this.fRunners = Collections.unmodifiableList(r);
    }

    private ContractImpl getContractImpl(Class<?> cls, List<Throwable> errors) {
        ContractImpl impl = cls.getAnnotation(ContractImpl.class);
        if (impl == null) {
            errors.add(new IllegalArgumentException("Classes annotated as @RunWith( ContractSuite ) [" + cls + "] must also be annotated with @ContractImpl"));
        }
        return impl;
    }

    private List<Runner> addDynamicClasses(RunnerBuilder builder, List<Throwable> errors, ContractTestMap contractTestMap, Dynamic dynamic) throws InitializationError {
        Class<?> cls = dynamic.getClass();
        ArrayList<Runner> r = new ArrayList<Runner>();
        ContractImpl impl = this.getContractImpl(cls, errors);
        if (impl == null) {
            return r;
        }
        DynamicSuiteInfo dynamicSuiteInfo = null;
        try {
            dynamicSuiteInfo = new DynamicSuiteInfo((Class<? extends Dynamic>)cls, impl);
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
            return r;
        }
        Collection<Class<?>> tests = dynamic.getSuiteClasses();
        if (tests == null || tests.size() == 0) {
            errors.add(new IllegalStateException("Dynamic suite did not return a list of classes to execute"));
        } else {
            for (Class<?> test : tests) {
                RunWith runwith = test.getAnnotation(RunWith.class);
                if (runwith != null && runwith.value().equals(ContractSuite.class)) {
                    impl = this.getContractImpl(test, errors);
                    if (impl == null) continue;
                    try {
                        DynamicTestInfo parentTestInfo = new DynamicTestInfo(test, impl, dynamicSuiteInfo);
                        this.addSpecifiedClasses(r, test, builder, errors, contractTestMap, dynamic, parentTestInfo);
                    }
                    catch (IllegalStateException e) {
                        errors.add(e);
                    }
                    continue;
                }
                try {
                    r.add(builder.runnerForClass(test));
                }
                catch (Throwable t) {
                    errors.add(t);
                }
            }
        }
        return r;
    }

    private List<Runner> addAnnotatedClasses(Class<?> cls, RunnerBuilder builder, List<Throwable> errors, ContractTestMap contractTestMap, Object baseObj) throws InitializationError {
        ArrayList<Runner> r = new ArrayList<Runner>();
        ContractImpl impl = this.getContractImpl(cls, errors);
        if (impl != null) {
            TestInfo testInfo = contractTestMap.getInfoByTestClass(impl.value());
            if (testInfo == null) {
                testInfo = new SuiteInfo(cls, impl);
                contractTestMap.add(testInfo);
            }
            this.addSpecifiedClasses(r, cls, builder, errors, contractTestMap, baseObj, testInfo);
        }
        return r;
    }

    private void addSpecifiedClasses(List<Runner> r, Class<?> cls, RunnerBuilder builder, List<Throwable> errors, ContractTestMap contractTestMap, Object baseObj, TestInfo parentTestInfo) throws InitializationError {
        LinkedHashSet<TestInfo> testClasses = new LinkedHashSet<TestInfo>();
        BaseClassRunner bcr = new BaseClassRunner(cls);
        if (bcr.computeTestMethods().size() > 0) {
            r.add((Runner)bcr);
        }
        for (TestInfo testInfo : contractTestMap.getAnnotatedClasses(testClasses, parentTestInfo)) {
            r.add((Runner)new ContractTestRunner(baseObj, parentTestInfo, testInfo));
        }
        if (r.size() == 0) {
            errors.add(new IllegalArgumentException("No tests for " + cls));
        }
    }

    protected List<Runner> getChildren() {
        return this.fRunners;
    }

    protected Description describeChild(Runner child) {
        return child.getDescription();
    }

    protected void runChild(Runner child, RunNotifier notifier) {
        child.run(notifier);
    }

    private static ContractTestMap populateAnnotatedClassContainers(List<Throwable> errors) {
        ContractTestMap retval = new ContractTestMap();
        for (Class<?> clazz : ClassPathUtils.getClasses("")) {
            Contract c = clazz.getAnnotation(Contract.class);
            if (c == null) continue;
            try {
                retval.add(new TestInfo(clazz, c));
            }
            catch (IllegalStateException e) {
                errors.add(e);
            }
        }
        return retval;
    }

    private class BaseClassRunner
    extends BlockJUnit4ClassRunner {
        private List<FrameworkMethod> testMethods;

        public BaseClassRunner(Class<?> cls) throws InitializationError {
            super(cls);
            this.testMethods = null;
        }

        protected Statement withAfterClasses(Statement statement) {
            return statement;
        }

        protected Statement withBeforeClasses(Statement statement) {
            return statement;
        }

        protected void validateInstanceMethods(List<Throwable> errors) {
            this.validatePublicVoidNoArgMethods(After.class, false, errors);
            this.validatePublicVoidNoArgMethods(Before.class, false, errors);
            this.validateTestMethods(errors);
        }

        protected List<FrameworkMethod> computeTestMethods() {
            if (this.testMethods == null) {
                this.testMethods = new ArrayList<FrameworkMethod>();
                for (FrameworkMethod mthd : super.getTestClass().getAnnotatedMethods(ContractTest.class)) {
                    if (mthd.getMethod().getDeclaringClass().getAnnotation(Contract.class) != null) continue;
                    this.testMethods.add(mthd);
                }
            }
            return this.testMethods;
        }
    }

    private static class ContractTestMap {
        private Map<Class<?>, TestInfo> classToInfoMap = new HashMap();
        private Map<Class<?>, TestInfo> testToInfoMap = new HashMap();

        private ContractTestMap() {
        }

        public void add(TestInfo info) {
            this.classToInfoMap.put(info.getTestClass(), info);
            this.testToInfoMap.put(info.getContractClass(), info);
        }

        public TestInfo getInfoByTestClass(Class<?> testClass) {
            return this.classToInfoMap.get(testClass);
        }

        public TestInfo getInfoByContractClass(Class<?> contract) {
            return this.testToInfoMap.get(contract);
        }

        private void getAllInterfaces(Set<Class<?>> set, Class<?> c) {
            if (c == null || c == Object.class) {
                return;
            }
            for (Class<?> i : c.getClasses()) {
                if (!i.isInterface() || set.contains(i)) continue;
                set.add(i);
                this.getAllInterfaces(set, i);
            }
            for (Class<?> i : c.getInterfaces()) {
                if (set.contains(i)) continue;
                set.add(i);
                this.getAllInterfaces(set, i);
            }
            this.getAllInterfaces(set, c.getSuperclass());
        }

        public Set<TestInfo> getAnnotatedClasses(Set<TestInfo> testClasses, TestInfo contractClassInfo) {
            LinkedHashSet implClasses = new LinkedHashSet();
            this.getAllInterfaces(implClasses, contractClassInfo.getContractClass());
            List<Class<?>> lst = Arrays.asList(contractClassInfo.getSkipTests());
            for (Class clazz : implClasses) {
                if (lst.contains(clazz)) {
                    LOG.info(String.format("Skipping %s for %s", clazz, contractClassInfo));
                    continue;
                }
                TestInfo testInfo = this.getInfoByContractClass(clazz);
                if (testInfo != null) {
                    LOG.info(String.format("Checked %s found %s", clazz, testInfo));
                    testClasses.add(testInfo);
                    continue;
                }
                LOG.info(String.format("Checked %s found nothing", clazz));
            }
            return testClasses;
        }
    }
}

