/*
 * Decompiled with CFR 0.152.
 */
package wiremock.org.eclipse.jetty.util;

import java.nio.ByteBuffer;
import wiremock.org.eclipse.jetty.util.Utf8StringBuilder;

public class Utf8LineParser {
    private State state = State.START;
    private Utf8StringBuilder utf;

    public String parse(ByteBuffer buf) {
        while (buf.remaining() > 0) {
            byte b = buf.get();
            if (!this.parseByte(b)) continue;
            this.state = State.START;
            return this.utf.toString();
        }
        return null;
    }

    private boolean parseByte(byte b) {
        switch (this.state.ordinal()) {
            case 0: {
                this.utf = new Utf8StringBuilder();
                this.state = State.PARSE;
                return this.parseByte(b);
            }
            case 1: {
                if (this.utf.isUtf8SequenceComplete() && (b == 13 || b == 10)) {
                    this.state = State.END;
                    return this.parseByte(b);
                }
                this.utf.append(b);
                return false;
            }
            case 2: {
                if (b == 10) {
                    this.state = State.START;
                    return true;
                }
                return false;
            }
        }
        throw new IllegalStateException();
    }

    private static enum State {
        START,
        PARSE,
        END;

    }
}

