/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.http;

import com.github.tomakehurst.wiremock.matching.MatchResult;
import com.github.tomakehurst.wiremock.matching.NamedValueMatcher;
import com.github.tomakehurst.wiremock.stubbing.SubEvent;
import java.util.Arrays;
import wiremock.com.fasterxml.jackson.annotation.JsonCreator;
import wiremock.com.fasterxml.jackson.annotation.JsonValue;

public class RequestMethod
implements NamedValueMatcher<RequestMethod> {
    public static final RequestMethod GET = new RequestMethod("GET");
    public static final RequestMethod POST = new RequestMethod("POST");
    public static final RequestMethod PUT = new RequestMethod("PUT");
    public static final RequestMethod DELETE = new RequestMethod("DELETE");
    public static final RequestMethod PATCH = new RequestMethod("PATCH");
    public static final RequestMethod OPTIONS = new RequestMethod("OPTIONS");
    public static final RequestMethod HEAD = new RequestMethod("HEAD");
    public static final RequestMethod TRACE = new RequestMethod("TRACE");
    public static final RequestMethod ANY = new RequestMethod("ANY");
    public static final RequestMethod GET_OR_HEAD = new RequestMethod("GET_OR_HEAD");
    private final String name;

    public RequestMethod(String name) {
        if (name == null) {
            throw new NullPointerException("Method name cannot be null");
        }
        this.name = name;
    }

    @JsonCreator
    public static RequestMethod fromString(String value) {
        return new RequestMethod(value);
    }

    @JsonValue
    public String value() {
        return this.name;
    }

    public boolean isOneOf(RequestMethod ... methods) {
        return Arrays.asList(methods).contains(this);
    }

    @Override
    public MatchResult match(RequestMethod method) {
        boolean getOrHeadMatch = this.equals(GET_OR_HEAD) && (method.equals(GET) || method.equals(HEAD));
        return MatchResult.of(this.equals(ANY) || this.equals(method) || getOrHeadMatch, new SubEvent[0]);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getExpected() {
        return this.getName();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RequestMethod that = (RequestMethod)o;
        return this.name.equals(that.name);
    }

    public boolean hasEntity() {
        return Arrays.asList(PUT, PATCH, POST).contains(this);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public String toString() {
        return this.name;
    }

    public static RequestMethod[] values() {
        return new RequestMethod[]{GET, POST, PUT, DELETE, PATCH, OPTIONS, HEAD, TRACE, ANY, GET_OR_HEAD};
    }
}

