/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.http;

import com.github.tomakehurst.wiremock.WireMockServer;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class JvmProxyConfigurer {
    private static final String HTTP_PROXY_HOST = "http.proxyHost";
    private static final String HTTP_PROXY_PORT = "http.proxyPort";
    private static final String HTTPS_PROXY_HOST = "https.proxyHost";
    private static final String HTTPS_PROXY_PORT = "https.proxyPort";
    private static final String HTTP_NON_PROXY_HOSTS = "http.nonProxyHosts";
    private static final List<String> ALL_PROXY_SETTINGS = Arrays.asList("http.proxyHost", "http.proxyPort", "https.proxyHost", "https.proxyPort", "http.nonProxyHosts");
    private static final Map<String, String> previousSettings = new HashMap<String, String>();

    public static void configureFor(WireMockServer wireMockServer) {
        JvmProxyConfigurer.stashPreviousSettings();
        JvmProxyConfigurer.configureFor(wireMockServer.port());
    }

    public static void configureFor(int port) {
        System.setProperty(HTTP_PROXY_HOST, "localhost");
        System.setProperty(HTTP_PROXY_PORT, String.valueOf(port));
        System.setProperty(HTTPS_PROXY_HOST, "localhost");
        System.setProperty(HTTPS_PROXY_PORT, String.valueOf(port));
        System.setProperty(HTTP_NON_PROXY_HOSTS, "localhost|127.*|[::1]");
    }

    public static void restorePrevious() {
        ALL_PROXY_SETTINGS.forEach(key -> {
            String previous = previousSettings.get(key);
            if (previous == null) {
                System.clearProperty(key);
            } else {
                System.setProperty(key, previous);
            }
        });
    }

    private static void stashPreviousSettings() {
        ALL_PROXY_SETTINGS.forEach(key -> previousSettings.put((String)key, System.getProperty(key)));
    }
}

