/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.common;

import com.github.tomakehurst.wiremock.common.Json;
import com.github.tomakehurst.wiremock.common.Strings;
import com.github.tomakehurst.wiremock.common.TextType;
import com.github.tomakehurst.wiremock.common.xml.Xml;
import com.github.tomakehurst.wiremock.http.ContentTypeHeader;
import java.net.URI;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import wiremock.com.fasterxml.jackson.databind.JsonNode;
import wiremock.org.apache.commons.lang3.StringUtils;

public class ContentTypes {
    public static final String CONTENT_TYPE = "Content-Type";
    public static final String CONTENT_LENGTH = "Content-Length";
    public static final String CONTENT_ENCODING = "Content-Encoding";
    public static final String TRANSFER_ENCODING = "Transfer-Encoding";
    public static final String OCTET_STREAM = "application/octet-stream";
    public static final String LOCATION = "Location";
    public static final String AUTHORIZATION = "Authorization";
    public static final String ACCEPT = "Accept";
    public static final String COOKIE = "Cookie";
    public static final String APPLICATION_JSON = "application/json";
    private static final Map<String, String> COMMON_MIME_TYPES = Map.ofEntries(Map.entry("image/jpeg", "jpeg"), Map.entry("image/gif", "gif"), Map.entry("image/tiff", "tiff"), Map.entry("image/png", "png"), Map.entry("image/x-icon", "ico"), Map.entry("image/svg+xml", "svg"), Map.entry("audio/x-aiff", "aiff"), Map.entry("video/x-ms-asf", "asf"), Map.entry("video/mpeg", "mp2"), Map.entry("audio/mpeg", "mp3"), Map.entry("video/quicktime", "mov"), Map.entry("application/pdf", "pdf"));
    public static final List<String> TEXT_FILE_EXTENSIONS = Arrays.asList("txt", "json", "xml", "html", "htm", "yaml", "csv");
    public static final List<String> TEXT_MIME_TYPE_PATTERNS = Arrays.asList(".*text.*", ".*json.*", ".*xml.*", ".*html.*", ".*yaml.*", ".*csv.*", ".*x-www-form-urlencoded.*");

    private ContentTypes() {
    }

    public static String determineFileExtension(String url, ContentTypeHeader contentTypeHeader, byte[] responseBody) {
        String path;
        String lastPathSegment;
        if (contentTypeHeader.isPresent()) {
            if (contentTypeHeader.mimeTypePart().contains("json")) {
                return "json";
            }
            if (contentTypeHeader.mimeTypePart().contains("xml")) {
                return "xml";
            }
            if (contentTypeHeader.mimeTypePart().contains("text")) {
                return "txt";
            }
            String extension = COMMON_MIME_TYPES.get(contentTypeHeader.mimeTypePart());
            if (extension != null) {
                return extension;
            }
        }
        if ((lastPathSegment = StringUtils.substringAfterLast(path = URI.create(url).getPath(), "/")).indexOf(46) != -1) {
            return StringUtils.substringAfterLast(lastPathSegment, ".");
        }
        return ContentTypes.determineTextFileExtension(Strings.stringFromBytes(responseBody, contentTypeHeader.charset()));
    }

    public static TextType determineTextType(String content) {
        try {
            Json.read(content, JsonNode.class);
            return TextType.JSON;
        }
        catch (Exception e) {
            try {
                Xml.read(content);
                return TextType.XML;
            }
            catch (Exception e1) {
                return TextType.PLAIN_TEXT;
            }
        }
    }

    public static String determineTextFileExtension(String content) {
        TextType textType = ContentTypes.determineTextType(content);
        switch (textType) {
            case JSON: {
                return "json";
            }
            case XML: {
                return "xml";
            }
        }
        return "txt";
    }

    public static boolean determineIsTextFromExtension(String extension) {
        return TEXT_FILE_EXTENSIONS.contains(extension);
    }

    public static boolean determineIsTextFromMimeType(String mimeType) {
        return TEXT_MIME_TYPE_PATTERNS.stream().anyMatch(pattern -> mimeType != null && mimeType.matches((String)pattern));
    }

    public static boolean determineIsText(String extension, String mimeType) {
        return ContentTypes.determineIsTextFromExtension(extension) || ContentTypes.determineIsTextFromMimeType(mimeType);
    }
}

