/*
 * Decompiled with CFR 0.152.
 */
package wiremock.com.networknt.schema;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import wiremock.com.fasterxml.jackson.databind.JsonNode;
import wiremock.com.fasterxml.jackson.databind.node.ObjectNode;
import wiremock.com.networknt.schema.BaseJsonValidator;
import wiremock.com.networknt.schema.CollectorContext;
import wiremock.com.networknt.schema.JsonSchema;
import wiremock.com.networknt.schema.ValidationContext;
import wiremock.com.networknt.schema.ValidationMessage;
import wiremock.com.networknt.schema.ValidatorState;
import wiremock.com.networknt.schema.ValidatorTypeCode;
import wiremock.org.slf4j.Logger;
import wiremock.org.slf4j.LoggerFactory;

public class AllOfValidator
extends BaseJsonValidator {
    private static final Logger logger = LoggerFactory.getLogger(AllOfValidator.class);
    private final List<JsonSchema> schemas = new ArrayList<JsonSchema>();

    public AllOfValidator(String schemaPath, JsonNode schemaNode, JsonSchema parentSchema, ValidationContext validationContext) {
        super(schemaPath, schemaNode, parentSchema, ValidatorTypeCode.ALL_OF, validationContext);
        this.validationContext = validationContext;
        int size = schemaNode.size();
        for (int i = 0; i < size; ++i) {
            this.schemas.add(validationContext.newSchema(schemaPath + "/" + i, schemaNode.get(i), parentSchema));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<ValidationMessage> validate(JsonNode node, JsonNode rootNode, String at) {
        AllOfValidator.debug(logger, node, rootNode, at);
        CollectorContext collectorContext = CollectorContext.getInstance();
        ValidatorState state = (ValidatorState)collectorContext.get("wiremock.com.networknt.schema.ValidatorState");
        LinkedHashSet<Object> childSchemaErrors = new LinkedHashSet<Object>();
        for (JsonSchema schema : this.schemas) {
            Set<Object> localErrors = new HashSet();
            CollectorContext.Scope parentScope = collectorContext.enterDynamicScope();
            try {
                localErrors = !state.isWalkEnabled() ? schema.validate(node, rootNode, at) : schema.walk(node, rootNode, at, true);
                childSchemaErrors.addAll(localErrors);
                if (!this.validationContext.getConfig().isOpenAPI3StyleDiscriminators()) continue;
                Iterator<JsonNode> arrayElements = this.schemaNode.elements();
                while (arrayElements.hasNext()) {
                    ObjectNode discriminator;
                    ValidationContext.DiscriminatorContext currentDiscriminatorContext;
                    ObjectNode allOfEntry = (ObjectNode)arrayElements.next();
                    JsonNode $ref = allOfEntry.get("$ref");
                    if (null == $ref || null == (currentDiscriminatorContext = this.validationContext.getCurrentDiscriminatorContext()) || null == (discriminator = currentDiscriminatorContext.getDiscriminatorForPath(allOfEntry.get("$ref").asText()))) continue;
                    AllOfValidator.registerAndMergeDiscriminator(currentDiscriminatorContext, discriminator, this.parentSchema, at);
                    String discriminatorPropertyName = discriminator.get("propertyName").asText();
                    JsonNode discriminatorNode = node.get(discriminatorPropertyName);
                    String discriminatorPropertyValue = discriminatorNode == null ? null : discriminatorNode.textValue();
                    JsonSchema jsonSchema = this.parentSchema;
                    AllOfValidator.checkDiscriminatorMatch(currentDiscriminatorContext, discriminator, discriminatorPropertyValue, jsonSchema);
                }
            }
            finally {
                CollectorContext.Scope scope = collectorContext.exitDynamicScope();
                if (!localErrors.isEmpty()) continue;
                parentScope.mergeWith(scope);
            }
        }
        return Collections.unmodifiableSet(childSchemaErrors);
    }

    @Override
    public Set<ValidationMessage> walk(JsonNode node, JsonNode rootNode, String at, boolean shouldValidateSchema) {
        if (shouldValidateSchema) {
            return this.validate(node, rootNode, at);
        }
        for (JsonSchema schema : this.schemas) {
            schema.walk(node, rootNode, at, false);
        }
        return Collections.emptySet();
    }

    @Override
    public void preloadJsonSchema() {
        this.preloadJsonSchemas(this.schemas);
    }
}

