/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.store.files;

import com.github.tomakehurst.wiremock.common.FileSource;
import com.github.tomakehurst.wiremock.common.InputStreamSource;
import com.github.tomakehurst.wiremock.common.SingleRootFileSource;
import com.github.tomakehurst.wiremock.common.StreamSources;
import com.github.tomakehurst.wiremock.common.TextFile;
import com.github.tomakehurst.wiremock.store.BlobStore;
import com.github.tomakehurst.wiremock.store.files.PathBased;
import java.io.File;
import java.io.InputStream;
import java.util.Optional;
import java.util.stream.Stream;
import org.wiremock.annotations.Beta;

@Beta(justification="Externalized State API: https://github.com/wiremock/wiremock/issues/2144")
public class FileSourceBlobStore
implements BlobStore,
PathBased {
    private final FileSource fileSource;

    FileSourceBlobStore(String root) {
        this.fileSource = new SingleRootFileSource(root);
    }

    public FileSourceBlobStore(FileSource fileSource) {
        this.fileSource = fileSource;
    }

    @Override
    public Optional<InputStream> getStream(String key) {
        return Optional.of(this.fileSource.getBinaryFileNamed(key).getStream());
    }

    @Override
    public InputStreamSource getStreamSource(String key) {
        return StreamSources.forBlobStoreItem(this, key);
    }

    @Override
    public Stream<String> getAllKeys() {
        String rootPath = new File(this.fileSource.getUri().getSchemeSpecificPart()).getPath();
        return this.fileSource.listFilesRecursively().stream().map(TextFile::getPath).map(path -> path.substring(rootPath.length() + 1));
    }

    @Override
    public Optional<byte[]> get(String key) {
        return Optional.of(this.fileSource.getBinaryFileNamed(key).readContents());
    }

    @Override
    public void put(String key, byte[] content) {
        this.fileSource.writeBinaryFile(key, content);
    }

    @Override
    public void remove(String key) {
        this.fileSource.deleteFile(key);
    }

    @Override
    public void clear() {
        this.fileSource.listFilesRecursively().forEach(file -> this.fileSource.deleteFile(file.getPath()));
    }

    public FileSource getFileSource() {
        return this.fileSource;
    }

    @Override
    public String getPath() {
        return this.fileSource.getPath();
    }
}

