/*
 * Decompiled with CFR 0.152.
 */
package wiremock.com.networknt.schema;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import wiremock.com.fasterxml.jackson.databind.JsonNode;
import wiremock.com.fasterxml.jackson.databind.node.ObjectNode;
import wiremock.com.networknt.schema.BaseJsonValidator;
import wiremock.com.networknt.schema.DiscriminatorContext;
import wiremock.com.networknt.schema.DiscriminatorValidator;
import wiremock.com.networknt.schema.ExecutionContext;
import wiremock.com.networknt.schema.JsonNodePath;
import wiremock.com.networknt.schema.JsonSchema;
import wiremock.com.networknt.schema.JsonSchemaException;
import wiremock.com.networknt.schema.JsonType;
import wiremock.com.networknt.schema.JsonValidator;
import wiremock.com.networknt.schema.MessageSourceValidationMessage;
import wiremock.com.networknt.schema.SchemaLocation;
import wiremock.com.networknt.schema.TypeFactory;
import wiremock.com.networknt.schema.ValidationContext;
import wiremock.com.networknt.schema.ValidationMessage;
import wiremock.com.networknt.schema.ValidatorTypeCode;
import wiremock.com.networknt.schema.utils.SetView;
import wiremock.org.slf4j.Logger;
import wiremock.org.slf4j.LoggerFactory;

public class OneOfValidator
extends BaseJsonValidator {
    private static final Logger logger = LoggerFactory.getLogger(OneOfValidator.class);
    private final List<JsonSchema> schemas;
    private Boolean canShortCircuit = null;

    public OneOfValidator(SchemaLocation schemaLocation, JsonNodePath evaluationPath, JsonNode schemaNode, JsonSchema parentSchema, ValidationContext validationContext) {
        super(schemaLocation, evaluationPath, schemaNode, parentSchema, ValidatorTypeCode.ONE_OF, validationContext);
        if (!schemaNode.isArray()) {
            JsonType nodeType = TypeFactory.getValueNodeType(schemaNode, this.validationContext.getConfig());
            throw new JsonSchemaException(((MessageSourceValidationMessage.Builder)((MessageSourceValidationMessage.Builder)((MessageSourceValidationMessage.Builder)((MessageSourceValidationMessage.Builder)this.message().instanceNode(schemaNode)).instanceLocation(schemaLocation.getFragment())).messageKey("type")).arguments(nodeType.toString(), "array")).build());
        }
        int size = schemaNode.size();
        this.schemas = new ArrayList<JsonSchema>(size);
        for (int i = 0; i < size; ++i) {
            JsonNode childNode = schemaNode.get(i);
            this.schemas.add(validationContext.newSchema(schemaLocation.append(i), evaluationPath.append(i), childNode, parentSchema));
        }
    }

    @Override
    public Set<ValidationMessage> validate(ExecutionContext executionContext, JsonNode node, JsonNode rootNode, JsonNodePath instanceLocation) {
        return this.validate(executionContext, node, rootNode, instanceLocation, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Set<ValidationMessage> validate(ExecutionContext executionContext, JsonNode node, JsonNode rootNode, JsonNodePath instanceLocation, boolean walk) {
        Set<ValidationMessage> errors = null;
        OneOfValidator.debug(logger, executionContext, node, rootNode, instanceLocation);
        int numberOfValidSchema = 0;
        int index = 0;
        SetView<Object> childErrors = null;
        ArrayList<String> indexes = null;
        boolean failFast = executionContext.isFailFast();
        try {
            DiscriminatorValidator discriminator = null;
            if (this.validationContext.getConfig().isDiscriminatorKeywordEnabled()) {
                DiscriminatorContext discriminatorContext = new DiscriminatorContext();
                executionContext.enterDiscriminatorContext(discriminatorContext, instanceLocation);
                discriminator = this.getParentSchema().getValidators().stream().filter(v -> "discriminator".equals(v.getKeyword())).findFirst().orElse(null);
                if (discriminator != null) {
                    discriminatorContext.registerDiscriminator(discriminator.getSchemaLocation(), (ObjectNode)discriminator.getSchemaNode());
                }
            }
            executionContext.setFailFast(false);
            for (JsonSchema schema : this.schemas) {
                Set<Object> schemaErrors = Collections.emptySet();
                schemaErrors = !walk ? schema.validate(executionContext, node, rootNode, instanceLocation) : schema.walk(executionContext, node, rootNode, instanceLocation, true);
                if (schemaErrors.isEmpty()) {
                    ++numberOfValidSchema;
                    if (indexes == null) {
                        indexes = new ArrayList<String>();
                    }
                    indexes.add(Integer.toString(index));
                }
                if (numberOfValidSchema > 1 && this.canShortCircuit()) break;
                if (this.validationContext.getConfig().isDiscriminatorKeywordEnabled()) {
                    DiscriminatorContext currentDiscriminatorContext;
                    if (discriminator != null && !discriminator.getPropertyName().isEmpty()) {
                        JsonNode discriminatorPropertyNode = node.get(discriminator.getPropertyName());
                        if (discriminatorPropertyNode != null) {
                            String ref;
                            String discriminatorPropertyValue = discriminatorPropertyNode.asText();
                            discriminatorPropertyValue = discriminator.getMapping().getOrDefault(discriminatorPropertyValue, discriminatorPropertyValue);
                            JsonNode refNode = schema.getSchemaNode().get("$ref");
                            if (refNode != null && ((ref = refNode.asText()).equals(discriminatorPropertyValue) || ref.endsWith("/" + discriminatorPropertyValue))) {
                                executionContext.getCurrentDiscriminatorContext().markMatch();
                            }
                        } else {
                            executionContext.getCurrentDiscriminatorContext().markIgnore();
                        }
                    }
                    if ((currentDiscriminatorContext = executionContext.getCurrentDiscriminatorContext()).isDiscriminatorMatchFound() && childErrors == null) {
                        childErrors = new SetView();
                        childErrors.union(schemaErrors);
                    } else if (currentDiscriminatorContext.isDiscriminatorIgnore() || !currentDiscriminatorContext.isActive()) {
                        if (childErrors == null) {
                            childErrors = new SetView();
                        }
                        childErrors.union(schemaErrors);
                    }
                } else if (!schemaErrors.isEmpty() && this.reportChildErrors(executionContext)) {
                    if (childErrors == null) {
                        childErrors = new SetView<Object>();
                    }
                    childErrors.union(schemaErrors);
                }
                ++index;
            }
            if (this.validationContext.getConfig().isDiscriminatorKeywordEnabled() && (discriminator != null || executionContext.getCurrentDiscriminatorContext().isActive()) && !executionContext.getCurrentDiscriminatorContext().isDiscriminatorMatchFound() && !executionContext.getCurrentDiscriminatorContext().isDiscriminatorIgnore()) {
                errors = Collections.singleton(((MessageSourceValidationMessage.Builder)((MessageSourceValidationMessage.Builder)((MessageSourceValidationMessage.Builder)((MessageSourceValidationMessage.Builder)this.message().instanceNode(node)).instanceLocation(instanceLocation)).locale(executionContext.getExecutionConfig().getLocale())).arguments("based on the provided discriminator. No alternative could be chosen based on the discriminator property")).build());
            }
        }
        finally {
            executionContext.setFailFast(failFast);
            if (this.validationContext.getConfig().isDiscriminatorKeywordEnabled()) {
                executionContext.leaveDiscriminatorContextImmediately(instanceLocation);
            }
        }
        if (numberOfValidSchema != 1 && errors == null) {
            ValidationMessage message = ((MessageSourceValidationMessage.Builder)((MessageSourceValidationMessage.Builder)((MessageSourceValidationMessage.Builder)((MessageSourceValidationMessage.Builder)((MessageSourceValidationMessage.Builder)((MessageSourceValidationMessage.Builder)this.message().instanceNode(node)).instanceLocation(instanceLocation)).messageKey(numberOfValidSchema > 1 ? "oneOf.indexes" : "oneOf")).locale(executionContext.getExecutionConfig().getLocale())).failFast(executionContext.isFailFast())).arguments(Integer.toString(numberOfValidSchema), numberOfValidSchema > 1 ? String.join((CharSequence)", ", indexes) : "")).build();
            errors = childErrors != null ? new SetView<ValidationMessage>().union(Collections.singleton(message)).union(childErrors) : Collections.singleton(message);
        }
        return errors != null ? errors : Collections.emptySet();
    }

    protected boolean reportChildErrors(ExecutionContext executionContext) {
        return !executionContext.getExecutionConfig().isFailFast();
    }

    protected boolean canShortCircuit() {
        if (this.canShortCircuit == null) {
            boolean canShortCircuit = true;
            for (JsonValidator validator : this.getEvaluationParentSchema().getValidators()) {
                if (!"unevaluatedProperties".equals(validator.getKeyword()) && !"unevaluatedItems".equals(validator.getKeyword())) continue;
                canShortCircuit = false;
            }
            this.canShortCircuit = canShortCircuit;
        }
        return this.canShortCircuit;
    }

    @Override
    public Set<ValidationMessage> walk(ExecutionContext executionContext, JsonNode node, JsonNode rootNode, JsonNodePath instanceLocation, boolean shouldValidateSchema) {
        LinkedHashSet<ValidationMessage> validationMessages = new LinkedHashSet<ValidationMessage>();
        if (shouldValidateSchema) {
            validationMessages.addAll(this.validate(executionContext, node, rootNode, instanceLocation, true));
        } else {
            for (JsonSchema schema : this.schemas) {
                schema.walk(executionContext, node, rootNode, instanceLocation, shouldValidateSchema);
            }
        }
        return validationMessages;
    }

    @Override
    public void preloadJsonSchema() {
        for (JsonSchema schema : this.schemas) {
            schema.initializeValidators();
        }
        this.canShortCircuit();
    }
}

