/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.admin;

import com.github.tomakehurst.wiremock.admin.AdminTask;
import com.github.tomakehurst.wiremock.admin.NotFoundException;
import com.github.tomakehurst.wiremock.admin.model.ScenarioState;
import com.github.tomakehurst.wiremock.client.ResponseDefinitionBuilder;
import com.github.tomakehurst.wiremock.common.Errors;
import com.github.tomakehurst.wiremock.common.Json;
import com.github.tomakehurst.wiremock.common.url.PathParams;
import com.github.tomakehurst.wiremock.core.Admin;
import com.github.tomakehurst.wiremock.http.ResponseDefinition;
import com.github.tomakehurst.wiremock.stubbing.ServeEvent;

public class SetScenarioStateTask
implements AdminTask {
    @Override
    public ResponseDefinition execute(Admin admin, ServeEvent serveEvent, PathParams pathParams) {
        String name = (String)pathParams.get("name");
        String body = serveEvent.getRequest().getBodyAsString();
        try {
            this.setOrResetScenarioState(admin, name, body);
        }
        catch (NotFoundException e) {
            return ResponseDefinitionBuilder.jsonResponse(Errors.single(404, e.getMessage()), 404);
        }
        return ResponseDefinition.okEmptyJson();
    }

    private void setOrResetScenarioState(Admin admin, String name, String body) {
        if (body != null && !body.isEmpty()) {
            ScenarioState scenarioState = Json.read(body, ScenarioState.class);
            admin.setScenarioState(name, scenarioState.getState());
        } else {
            admin.resetScenario(name);
        }
    }
}

