/*
 * Decompiled with CFR 0.152.
 */
package wiremock.org.xmlunit.util;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import wiremock.org.xmlunit.ConfigurationException;

public class DocumentBuilderFactoryConfigurer {
    private final Map<String, Object> attributes;
    private final Map<String, Object> safeAttributes;
    private final Map<String, Boolean> features;
    private final Map<String, Boolean> safeFeatures;
    private final boolean xIncludeAware;
    private final boolean expandEntityRefs;
    public static final DocumentBuilderFactoryConfigurer Default = DocumentBuilderFactoryConfigurer.builder().withDTDParsingDisabled().withDTDLoadingDisabled().withXIncludeAware(false).withExpandEntityReferences(false).build();

    private DocumentBuilderFactoryConfigurer(Map<String, Object> attributes, Map<String, Object> safeAttributes, Map<String, Boolean> features, Map<String, Boolean> safeFeatures, boolean xIncludeAware, boolean expandEntityRefs) {
        this.attributes = attributes;
        this.safeAttributes = safeAttributes;
        this.features = features;
        this.safeFeatures = safeFeatures;
        this.xIncludeAware = xIncludeAware;
        this.expandEntityRefs = expandEntityRefs;
    }

    public DocumentBuilderFactory configure(DocumentBuilderFactory factory) {
        for (Map.Entry<String, Object> entry : this.attributes.entrySet()) {
            try {
                factory.setAttribute(entry.getKey(), entry.getValue());
            }
            catch (IllegalArgumentException ex) {
                throw new ConfigurationException("Error setting attribute " + entry.getKey(), ex);
            }
        }
        for (Map.Entry<String, Object> entry : this.safeAttributes.entrySet()) {
            try {
                factory.setAttribute(entry.getKey(), entry.getValue());
            }
            catch (IllegalArgumentException ex) {}
        }
        for (Map.Entry<String, Object> entry : this.features.entrySet()) {
            try {
                factory.setFeature(entry.getKey(), (Boolean)entry.getValue());
            }
            catch (ParserConfigurationException ex) {
                throw new ConfigurationException("Error setting feature " + entry.getKey(), ex);
            }
        }
        for (Map.Entry<String, Object> entry : this.safeFeatures.entrySet()) {
            try {
                factory.setFeature(entry.getKey(), (Boolean)entry.getValue());
            }
            catch (ParserConfigurationException parserConfigurationException) {}
        }
        factory.setXIncludeAware(this.xIncludeAware);
        factory.setExpandEntityReferences(this.expandEntityRefs);
        return factory;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private final Map<String, Object> attributes = new HashMap<String, Object>();
        private final Map<String, Object> safeAttributes = new HashMap<String, Object>();
        private final Map<String, Boolean> features = new HashMap<String, Boolean>();
        private final Map<String, Boolean> safeFeatures = new HashMap<String, Boolean>();
        private boolean xIncludeAware = false;
        private boolean expandEntityRefs = false;
        private static final List<String> DTD_LOAD_DISABLERS = Arrays.asList("http://xerces.apache.org/xerces-j/features.html#external-general-entities", "http://xerces.apache.org/xerces2-j/features.html#external-general-entities", "http://xml.org/sax/features/external-general-entities", "http://apache.org/xml/features/nonvalidating/load-dtd-grammar", "http://apache.org/xml/features/nonvalidating/load-external-dtd", "http://xerces.apache.org/xerces-j/features.html#external-parameter-entities", "http://xerces.apache.org/xerces2-j/features.html#external-parameter-entities", "http://xml.org/sax/features/external-parameter-entities");
        private static final List<String> DTD_PARSE_DISABLERS = Arrays.asList("http://xerces.apache.org/xerces2-j/features.html#disallow-doctype-decl", "http://apache.org/xml/features/disallow-doctype-decl");

        public DocumentBuilderFactoryConfigurer build() {
            return new DocumentBuilderFactoryConfigurer(Collections.unmodifiableMap(this.attributes), Collections.unmodifiableMap(this.safeAttributes), Collections.unmodifiableMap(this.features), Collections.unmodifiableMap(this.safeFeatures), this.xIncludeAware, this.expandEntityRefs);
        }

        public Builder withAttribute(String key, Object value) {
            this.attributes.put(key, value);
            return this;
        }

        public Builder withSafeAttribute(String key, Object value) {
            this.safeAttributes.put(key, value);
            return this;
        }

        public Builder withFeature(String key, boolean value) {
            this.features.put(key, value);
            return this;
        }

        public Builder withSafeFeature(String key, boolean value) {
            this.safeFeatures.put(key, value);
            return this;
        }

        public Builder withDTDLoadingDisabled() {
            for (String feature : DTD_LOAD_DISABLERS) {
                this.withSafeFeature(feature, false);
            }
            return this;
        }

        public Builder withDTDParsingDisabled() {
            for (String feature : DTD_PARSE_DISABLERS) {
                this.withSafeFeature(feature, false);
            }
            return this;
        }

        public Builder withXIncludeAware(boolean b) {
            this.xIncludeAware = b;
            return this;
        }

        public Builder withExpandEntityReferences(boolean b) {
            this.expandEntityRefs = b;
            return this;
        }
    }
}

