/*
 * Decompiled with CFR 0.152.
 */
package wiremock.com.networknt.schema;

import wiremock.com.fasterxml.jackson.databind.JsonNode;
import wiremock.com.fasterxml.jackson.databind.node.JsonNodeType;
import wiremock.com.networknt.schema.JsonType;
import wiremock.com.networknt.schema.SchemaValidatorsConfig;

public class TypeFactory {
    public static JsonType getSchemaNodeType(JsonNode node) {
        if (node.isTextual()) {
            String type = node.textValue();
            if ("object".equals(type)) {
                return JsonType.OBJECT;
            }
            if ("array".equals(type)) {
                return JsonType.ARRAY;
            }
            if ("string".equals(type)) {
                return JsonType.STRING;
            }
            if ("number".equals(type)) {
                return JsonType.NUMBER;
            }
            if ("integer".equals(type)) {
                return JsonType.INTEGER;
            }
            if ("boolean".equals(type)) {
                return JsonType.BOOLEAN;
            }
            if ("any".equals(type)) {
                return JsonType.ANY;
            }
            if ("null".equals(type)) {
                return JsonType.NULL;
            }
        }
        if (node.isArray()) {
            return JsonType.UNION;
        }
        return JsonType.UNKNOWN;
    }

    public static JsonType getValueNodeType(JsonNode node, SchemaValidatorsConfig config) {
        JsonNodeType type = node.getNodeType();
        switch (type) {
            case OBJECT: {
                return JsonType.OBJECT;
            }
            case ARRAY: {
                return JsonType.ARRAY;
            }
            case STRING: 
            case BINARY: {
                return JsonType.STRING;
            }
            case NUMBER: {
                if (node.isIntegralNumber()) {
                    return JsonType.INTEGER;
                }
                if (config != null && (config.isJavaSemantics() || config.isLosslessNarrowing()) && node.canConvertToExactIntegral()) {
                    return JsonType.INTEGER;
                }
                return JsonType.NUMBER;
            }
            case BOOLEAN: {
                return JsonType.BOOLEAN;
            }
            case NULL: {
                return JsonType.NULL;
            }
        }
        return JsonType.UNKNOWN;
    }
}

