/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.admin.tasks;

import com.github.tomakehurst.wiremock.admin.AdminTask;
import com.github.tomakehurst.wiremock.admin.LimitAndSinceDatePaginator;
import com.github.tomakehurst.wiremock.admin.model.GetServeEventsResult;
import com.github.tomakehurst.wiremock.admin.model.ServeEventQuery;
import com.github.tomakehurst.wiremock.client.ResponseDefinitionBuilder;
import com.github.tomakehurst.wiremock.common.InvalidInputException;
import com.github.tomakehurst.wiremock.common.Json;
import com.github.tomakehurst.wiremock.common.url.PathParams;
import com.github.tomakehurst.wiremock.core.Admin;
import com.github.tomakehurst.wiremock.http.ResponseDefinition;
import com.github.tomakehurst.wiremock.stubbing.ServeEvent;

public class GetAllRequestsTask
implements AdminTask {
    @Override
    public ResponseDefinition execute(Admin admin, ServeEvent serveEvent, PathParams pathParams) {
        LimitAndSinceDatePaginator paginator;
        ServeEventQuery query = ServeEventQuery.fromRequest(serveEvent.getRequest());
        GetServeEventsResult serveEventsResult = admin.getServeEvents(query);
        try {
            paginator = LimitAndSinceDatePaginator.fromRequest(serveEventsResult.getRequests(), serveEvent.getRequest());
        }
        catch (InvalidInputException e) {
            return ResponseDefinitionBuilder.jsonResponse(e.getErrors(), 400);
        }
        GetServeEventsResult result = new GetServeEventsResult(paginator, serveEventsResult.isRequestJournalDisabled());
        return ResponseDefinitionBuilder.responseDefinition().withStatus(200).withBody(Json.write(result)).withHeader("Content-Type", "application/json").build();
    }
}

