/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.standalone;

import com.github.tomakehurst.wiremock.WireMockServer;
import com.github.tomakehurst.wiremock.client.ResponseDefinitionBuilder;
import com.github.tomakehurst.wiremock.client.WireMock;
import com.github.tomakehurst.wiremock.common.FatalStartupException;
import com.github.tomakehurst.wiremock.common.FileSource;
import com.github.tomakehurst.wiremock.http.RequestMethod;
import com.github.tomakehurst.wiremock.http.ResponseDefinition;
import com.github.tomakehurst.wiremock.matching.RequestPattern;
import com.github.tomakehurst.wiremock.matching.RequestPatternBuilder;
import com.github.tomakehurst.wiremock.standalone.CommandLineOptions;
import com.github.tomakehurst.wiremock.stubbing.StubMapping;
import java.io.PrintStream;

public class WireMockServerRunner {
    private static final String BANNER = "\n\u001b[34m\u2588\u2588     \u2588\u2588 \u2588\u2588 \u2588\u2588\u2588\u2588\u2588\u2588  \u2588\u2588\u2588\u2588\u2588\u2588\u2588 \u001b[33m\u2588\u2588\u2588    \u2588\u2588\u2588  \u2588\u2588\u2588\u2588\u2588\u2588   \u2588\u2588\u2588\u2588\u2588\u2588 \u2588\u2588   \u2588\u2588 \n\u001b[34m\u2588\u2588     \u2588\u2588 \u2588\u2588 \u2588\u2588   \u2588\u2588 \u2588\u2588      \u001b[33m\u2588\u2588\u2588\u2588  \u2588\u2588\u2588\u2588 \u2588\u2588    \u2588\u2588 \u2588\u2588      \u2588\u2588  \u2588\u2588  \n\u001b[34m\u2588\u2588  \u2588  \u2588\u2588 \u2588\u2588 \u2588\u2588\u2588\u2588\u2588\u2588  \u2588\u2588\u2588\u2588\u2588   \u001b[33m\u2588\u2588 \u2588\u2588\u2588\u2588 \u2588\u2588 \u2588\u2588    \u2588\u2588 \u2588\u2588      \u2588\u2588\u2588\u2588\u2588   \n\u001b[34m\u2588\u2588 \u2588\u2588\u2588 \u2588\u2588 \u2588\u2588 \u2588\u2588   \u2588\u2588 \u2588\u2588      \u001b[33m\u2588\u2588  \u2588\u2588  \u2588\u2588 \u2588\u2588    \u2588\u2588 \u2588\u2588      \u2588\u2588  \u2588\u2588  \n\u001b[34m \u2588\u2588\u2588 \u2588\u2588\u2588  \u2588\u2588 \u2588\u2588   \u2588\u2588 \u2588\u2588\u2588\u2588\u2588\u2588\u2588 \u001b[33m\u2588\u2588      \u2588\u2588  \u2588\u2588\u2588\u2588\u2588\u2588   \u2588\u2588\u2588\u2588\u2588\u2588 \u2588\u2588   \u2588\u2588 \n\n\u001b[0m----------------------------------------------------------------\n|               Cloud: https://wiremock.io/cloud               |\n|                                                              |\n|               Slack: https://slack.wiremock.org              |\n----------------------------------------------------------------";
    private WireMockServer wireMockServer;

    public void run(String ... args) {
        WireMockServerRunner.suppressSlf4jWarnings();
        CommandLineOptions options = new CommandLineOptions(args);
        if (options.help()) {
            System.out.println(options.helpText());
            return;
        }
        FileSource fileSource = options.filesRoot();
        fileSource.createIfNecessary();
        FileSource filesFileSource = fileSource.child("__files");
        filesFileSource.createIfNecessary();
        FileSource mappingsFileSource = fileSource.child("mappings");
        mappingsFileSource.createIfNecessary();
        this.wireMockServer = new WireMockServer(options);
        if (options.recordMappingsEnabled()) {
            this.wireMockServer.enableRecordMappings(mappingsFileSource, filesFileSource);
        }
        if (options.specifiesProxyUrl()) {
            this.addProxyMapping(options.proxyUrl());
        }
        try {
            this.wireMockServer.start();
            boolean https = options.httpsSettings().enabled();
            if (!options.getHttpDisabled()) {
                options.setActualHttpPort(this.wireMockServer.port());
            }
            if (https) {
                options.setActualHttpsPort(this.wireMockServer.httpsPort());
            }
            if (!options.bannerDisabled()) {
                System.out.println(BANNER);
                System.out.println();
            } else {
                System.out.println();
                System.out.println("The WireMock server is started .....");
            }
            System.out.println(options);
        }
        catch (FatalStartupException e) {
            System.err.println(e.getMessage());
            System.exit(1);
        }
    }

    private static void suppressSlf4jWarnings() {
        System.setErr(new PrintStream(System.err){

            @Override
            public void println(String s2) {
                if (!s2.startsWith("SLF4J")) {
                    super.println(s2);
                }
            }

            @Override
            public void println(char[] chars) {
                if (!new String(chars).startsWith("SLF4J")) {
                    super.println(chars);
                }
            }

            @Override
            public void println(Object o) {
                if (!o.toString().startsWith("SLF4J")) {
                    super.println(o);
                }
            }
        });
    }

    private void addProxyMapping(String baseUrl) {
        this.wireMockServer.loadMappingsUsing(stubMappings -> {
            RequestPattern requestPattern = RequestPatternBuilder.newRequestPattern(RequestMethod.ANY, WireMock.anyUrl()).build();
            ResponseDefinition responseDef = ResponseDefinitionBuilder.responseDefinition().proxiedFrom(baseUrl).build();
            StubMapping proxyBasedMapping = new StubMapping(requestPattern, responseDef);
            proxyBasedMapping.setPriority(10);
            stubMappings.addMapping(proxyBasedMapping);
        });
    }

    public void stop() {
        if (this.wireMockServer != null) {
            this.wireMockServer.stop();
        }
    }

    public boolean isRunning() {
        if (this.wireMockServer == null) {
            return false;
        }
        return this.wireMockServer.isRunning();
    }

    public int port() {
        return this.wireMockServer.port();
    }
}

