/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.jetty.websocket;

import com.github.tomakehurst.wiremock.http.Request;
import com.github.tomakehurst.wiremock.jetty.websocket.JettyWebSocketSession;
import com.github.tomakehurst.wiremock.message.Message;
import com.github.tomakehurst.wiremock.message.MessageChannel;
import com.github.tomakehurst.wiremock.message.MessageDefinition;
import com.github.tomakehurst.wiremock.message.MessageStubRequestHandler;
import com.github.tomakehurst.wiremock.message.RequestInitiatedMessageChannel;
import com.github.tomakehurst.wiremock.message.websocket.WebSocketMessageChannel;
import com.github.tomakehurst.wiremock.message.websocket.WebSocketSession;
import java.nio.ByteBuffer;
import org.eclipse.jetty.websocket.api.Callback;
import org.eclipse.jetty.websocket.api.Session;

public class WireMockWebSocketEndpoint
implements Session.Listener.AutoDemanding {
    private final MessageStubRequestHandler messageStubRequestHandler;
    private final Request upgradeRequest;
    private RequestInitiatedMessageChannel messageChannel;

    public WireMockWebSocketEndpoint(MessageStubRequestHandler messageStubRequestHandler, Request upgradeRequest) {
        this.messageStubRequestHandler = messageStubRequestHandler;
        this.upgradeRequest = upgradeRequest;
    }

    public void onWebSocketOpen(Session session) {
        JettyWebSocketSession webSocketSession = new JettyWebSocketSession(session);
        this.messageChannel = new WebSocketMessageChannel(this.upgradeRequest, (WebSocketSession)webSocketSession);
        this.messageStubRequestHandler.getMessageChannels().add((MessageChannel)this.messageChannel);
    }

    public void onWebSocketText(String text) {
        if (this.messageStubRequestHandler != null && this.messageChannel != null) {
            Message message = MessageStubRequestHandler.resolveToMessage((MessageDefinition)MessageDefinition.fromString((String)text), null);
            this.messageStubRequestHandler.processMessage((MessageChannel)this.messageChannel, message);
        }
    }

    public void onWebSocketBinary(ByteBuffer payload, Callback callback) {
        if (this.messageStubRequestHandler != null && this.messageChannel != null) {
            byte[] data = new byte[payload.remaining()];
            payload.get(data);
            Message message = MessageStubRequestHandler.resolveToMessage((MessageDefinition)MessageDefinition.fromBytes((byte[])data), null);
            this.messageStubRequestHandler.processMessage((MessageChannel)this.messageChannel, message);
        }
        callback.succeed();
    }

    public void onWebSocketClose(int statusCode, String reason, Callback callback) {
        if (this.messageChannel != null) {
            this.messageStubRequestHandler.getMessageChannels().remove(this.messageChannel.getId());
        }
        callback.succeed();
    }

    public RequestInitiatedMessageChannel getMessageChannel() {
        return this.messageChannel;
    }
}

