/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.jetty.servlet;

import com.github.tomakehurst.wiremock.common.AsynchronousResponseSettings;
import com.github.tomakehurst.wiremock.common.BrowserProxySettings;
import com.github.tomakehurst.wiremock.common.DataTruncationSettings;
import com.github.tomakehurst.wiremock.common.FileSource;
import com.github.tomakehurst.wiremock.common.HttpsSettings;
import com.github.tomakehurst.wiremock.common.NetworkAddressRules;
import com.github.tomakehurst.wiremock.common.Notifier;
import com.github.tomakehurst.wiremock.common.ProxySettings;
import com.github.tomakehurst.wiremock.common.filemaker.FilenameMaker;
import com.github.tomakehurst.wiremock.core.MappingsSaver;
import com.github.tomakehurst.wiremock.core.Options;
import com.github.tomakehurst.wiremock.extension.ExtensionDeclarations;
import com.github.tomakehurst.wiremock.http.CaseInsensitiveKey;
import com.github.tomakehurst.wiremock.http.HttpServerFactory;
import com.github.tomakehurst.wiremock.http.client.HttpClientFactory;
import com.github.tomakehurst.wiremock.http.trafficlistener.DoNothingWiremockNetworkTrafficListener;
import com.github.tomakehurst.wiremock.http.trafficlistener.WiremockNetworkTrafficListener;
import com.github.tomakehurst.wiremock.jetty.servlet.ServletContextFileSource;
import com.github.tomakehurst.wiremock.security.Authenticator;
import com.github.tomakehurst.wiremock.security.NoAuthenticator;
import com.github.tomakehurst.wiremock.servlet.NotImplementedMappingsSaver;
import com.github.tomakehurst.wiremock.standalone.JsonFileMappingsSource;
import com.github.tomakehurst.wiremock.standalone.MappingsLoader;
import com.github.tomakehurst.wiremock.store.DefaultStores;
import com.github.tomakehurst.wiremock.store.Stores;
import jakarta.servlet.ServletContext;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;

public class WarConfiguration
implements Options {
    private static final String FILE_SOURCE_ROOT_KEY = "WireMockFileSourceRoot";
    private final ServletContext servletContext;

    public WarConfiguration(ServletContext servletContext) {
        this.servletContext = servletContext;
    }

    public int portNumber() {
        return 0;
    }

    public boolean getHttpDisabled() {
        return false;
    }

    public boolean getHttp2PlainDisabled() {
        return false;
    }

    public boolean getHttp2TlsDisabled() {
        return false;
    }

    public HttpsSettings httpsSettings() {
        return new HttpsSettings.Builder().build();
    }

    public int containerThreads() {
        return 0;
    }

    public boolean browserProxyingEnabled() {
        return false;
    }

    public ProxySettings proxyVia() {
        return ProxySettings.NO_PROXY;
    }

    public Stores getStores() {
        return new DefaultStores(this.filesRoot());
    }

    public FileSource filesRoot() {
        String fileSourceRoot = this.servletContext.getInitParameter(FILE_SOURCE_ROOT_KEY);
        return new ServletContextFileSource(this.servletContext, fileSourceRoot);
    }

    public MappingsLoader mappingsLoader() {
        return new JsonFileMappingsSource(this.filesRoot().child("mappings"), this.filesRoot().child("message-mappings"), new FilenameMaker());
    }

    public MappingsSaver mappingsSaver() {
        return new NotImplementedMappingsSaver();
    }

    public Notifier notifier() {
        return null;
    }

    public boolean requestJournalDisabled() {
        return false;
    }

    public Optional<Integer> maxRequestJournalEntries() {
        String str = this.servletContext.getInitParameter("maxRequestJournalEntries");
        if (str == null) {
            return Optional.empty();
        }
        return Optional.of(Integer.parseInt(str));
    }

    public String bindAddress() {
        return null;
    }

    public FilenameMaker getFilenameMaker() {
        return null;
    }

    public List<CaseInsensitiveKey> matchingHeaders() {
        return Collections.emptyList();
    }

    public boolean shouldPreserveHostHeader() {
        return false;
    }

    public boolean shouldPreserveUserAgentProxyHeader() {
        return false;
    }

    public String proxyHostHeader() {
        return null;
    }

    public HttpServerFactory httpServerFactory() {
        return null;
    }

    public HttpClientFactory httpClientFactory() {
        return null;
    }

    public ExtensionDeclarations getDeclaredExtensions() {
        return new ExtensionDeclarations();
    }

    public boolean isExtensionScanningEnabled() {
        return true;
    }

    public WiremockNetworkTrafficListener networkTrafficListener() {
        return new DoNothingWiremockNetworkTrafficListener();
    }

    public Authenticator getAdminAuthenticator() {
        return new NoAuthenticator();
    }

    public boolean getHttpsRequiredForAdminApi() {
        return false;
    }

    public AsynchronousResponseSettings getAsynchronousResponseSettings() {
        return new AsynchronousResponseSettings(false, 0);
    }

    public Options.ChunkedEncodingPolicy getChunkedEncodingPolicy() {
        return Options.ChunkedEncodingPolicy.ALWAYS;
    }

    public boolean getGzipDisabled() {
        return false;
    }

    public boolean getStubRequestLoggingDisabled() {
        return false;
    }

    public boolean getStubCorsEnabled() {
        return false;
    }

    public long timeout() {
        return 0L;
    }

    public boolean getDisableOptimizeXmlFactoriesLoading() {
        return false;
    }

    public boolean getDisableStrictHttpHeaders() {
        return false;
    }

    public DataTruncationSettings getDataTruncationSettings() {
        return DataTruncationSettings.DEFAULTS;
    }

    public NetworkAddressRules getProxyTargetRules() {
        return NetworkAddressRules.ALLOW_ALL;
    }

    public BrowserProxySettings browserProxySettings() {
        return BrowserProxySettings.DISABLED;
    }

    public int proxyTimeout() {
        return 300000;
    }

    public int getMaxHttpClientConnections() {
        return 1000;
    }

    public boolean getDisableConnectionReuse() {
        return true;
    }

    public boolean getResponseTemplatingEnabled() {
        return true;
    }

    public boolean getResponseTemplatingGlobal() {
        return false;
    }

    public Long getMaxTemplateCacheEntries() {
        return null;
    }

    public Set<String> getTemplatePermittedSystemKeys() {
        return null;
    }

    public boolean getTemplateEscapingDisabled() {
        return false;
    }

    public Set<String> getSupportedProxyEncodings() {
        return null;
    }

    public int getWebhookThreadPoolSize() {
        return 10;
    }

    public long getWebSocketIdleTimeout() {
        return 300000L;
    }

    public long getWebSocketMaxTextMessageSize() {
        return 0xA00000L;
    }

    public long getWebSocketMaxBinaryMessageSize() {
        return 0xA00000L;
    }
}

