/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.jetty.faults;

import com.github.tomakehurst.wiremock.core.FaultInjector;
import com.github.tomakehurst.wiremock.jetty.JettyHttpUtils;
import com.github.tomakehurst.wiremock.jetty.faults.JettyFaultInjector;
import com.github.tomakehurst.wiremock.jetty.faults.JettyHttpsFaultInjector;
import com.github.tomakehurst.wiremock.jetty.servlet.FaultInjectorFactory;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;

public class JettyFaultInjectorFactory
implements FaultInjectorFactory {
    private final JettyHttpUtils utils;

    public JettyFaultInjectorFactory(JettyHttpUtils utils) {
        this.utils = utils;
    }

    @Override
    public FaultInjector buildFaultInjector(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        if (httpServletRequest.getScheme().equals("https")) {
            return new JettyHttpsFaultInjector(httpServletResponse, this.utils);
        }
        return new JettyFaultInjector(httpServletResponse, this.utils);
    }
}

