/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.jetty;

import com.github.tomakehurst.wiremock.common.Exceptions;
import com.github.tomakehurst.wiremock.common.FatalStartupException;
import com.github.tomakehurst.wiremock.common.HttpsSettings;
import com.github.tomakehurst.wiremock.core.Options;
import com.github.tomakehurst.wiremock.http.AdminRequestHandler;
import com.github.tomakehurst.wiremock.http.HttpServer;
import com.github.tomakehurst.wiremock.http.StubRequestHandler;
import com.github.tomakehurst.wiremock.http.trafficlistener.WiremockNetworkTrafficListener;
import com.github.tomakehurst.wiremock.jetty.DefaultMultipartRequestConfigElementBuilder;
import com.github.tomakehurst.wiremock.jetty.JettySettings;
import com.github.tomakehurst.wiremock.jetty.servlet.MultipartRequestConfigElementBuilder;
import com.github.tomakehurst.wiremock.message.MessageStubRequestHandler;
import java.io.IOException;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.util.Optional;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.io.NetworkTrafficListener;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.util.thread.ThreadPool;

public abstract class JettyHttpServer
implements HttpServer {
    private static final AtomicBoolean STRICT_HTTP_HEADERS_APPLIED = new AtomicBoolean(false);
    private static final int MAX_RETRIES = 3;
    protected static final String FILES_URL_MATCH = String.format("/%s/*", "__files");
    protected static final String[] GZIPPABLE_METHODS = new String[]{"POST", "PUT", "PATCH", "DELETE"};
    protected final Options options;
    protected final JettySettings jettySettings;
    protected final Server jettyServer;
    protected final ServerConnector httpConnector;
    protected final ServerConnector httpsConnector;
    protected final MessageStubRequestHandler messageStubRequestHandler;
    protected ScheduledExecutorService scheduledExecutorService;

    public JettyHttpServer(Options options, AdminRequestHandler adminRequestHandler, StubRequestHandler stubRequestHandler, JettySettings jettySettings, ThreadPool threadPool, MessageStubRequestHandler messageStubRequestHandler) {
        this.options = options;
        this.jettySettings = jettySettings;
        this.messageStubRequestHandler = messageStubRequestHandler;
        if (!options.getDisableStrictHttpHeaders() && Boolean.FALSE.equals(STRICT_HTTP_HEADERS_APPLIED.get())) {
            System.setProperty("org.eclipse.jetty.http.HttpGenerator.STRICT", String.valueOf(true));
            STRICT_HTTP_HEADERS_APPLIED.set(true);
        }
        this.jettyServer = this.createServer(threadPool);
        NetworkTrafficListenerAdapter networkTrafficListenerAdapter = new NetworkTrafficListenerAdapter(options.networkTrafficListener());
        if (options.getHttpDisabled()) {
            this.httpConnector = null;
        } else {
            this.httpConnector = this.createHttpConnector(options.bindAddress(), options.portNumber(), jettySettings, networkTrafficListenerAdapter);
            this.jettyServer.addConnector((Connector)this.httpConnector);
        }
        if (options.httpsSettings().enabled()) {
            this.httpsConnector = this.createHttpsConnector(options.bindAddress(), options.httpsSettings(), jettySettings, networkTrafficListenerAdapter);
            this.jettyServer.addConnector((Connector)this.httpsConnector);
        } else {
            this.httpsConnector = null;
        }
        this.applyAdditionalServerConfiguration(this.jettyServer, options);
        Handler handlers = this.createHandler(options, adminRequestHandler, stubRequestHandler);
        this.jettyServer.setHandler(handlers);
        this.finalizeSetup();
    }

    protected void applyAdditionalServerConfiguration(Server jettyServer, Options options) {
    }

    protected abstract Handler createHandler(Options var1, AdminRequestHandler var2, StubRequestHandler var3);

    protected void finalizeSetup() {
        if (this.jettySettings.getStopTimeout().isEmpty()) {
            this.jettyServer.setStopTimeout(1000L);
        }
    }

    protected Server createServer(ThreadPool threadPool) {
        Server server = new Server(threadPool);
        Optional<Long> stopTimeout = this.jettySettings.getStopTimeout();
        stopTimeout.ifPresent(arg_0 -> ((Server)server).setStopTimeout(arg_0));
        return server;
    }

    public Handler[] extensionHandlers() {
        return new Handler[0];
    }

    public void start() {
        int retryCount = 0;
        while (retryCount < 3) {
            try {
                this.jettyServer.start();
                break;
            }
            catch (IOException bindException) {
                if (++retryCount < 3) continue;
                throw new FatalStartupException((Throwable)bindException);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        long timeout = System.currentTimeMillis() + 30000L;
        while (!this.jettyServer.isStarted()) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (System.currentTimeMillis() <= timeout) continue;
            throw new RuntimeException("Server took too long to start up.");
        }
    }

    public void stop() {
        try {
            if (this.scheduledExecutorService != null) {
                this.scheduledExecutorService.shutdown();
            }
            if (this.httpConnector != null) {
                this.httpConnector.getConnectedEndPoints().forEach(EndPoint::close);
            }
            if (this.httpsConnector != null) {
                this.httpsConnector.getConnectedEndPoints().forEach(EndPoint::close);
            }
            this.jettyServer.stop();
            this.jettyServer.join();
        }
        catch (TimeoutException timeoutException) {
        }
        catch (Exception e) {
            Exceptions.throwUnchecked((Throwable)e);
        }
    }

    public boolean isRunning() {
        return this.jettyServer.isRunning();
    }

    public int port() {
        return this.httpConnector.getLocalPort();
    }

    public int httpsPort() {
        return this.httpsConnector.getLocalPort();
    }

    public long stopTimeout() {
        return this.jettyServer.getStopTimeout();
    }

    protected abstract ServerConnector createHttpConnector(String var1, int var2, JettySettings var3, NetworkTrafficListener var4);

    protected abstract ServerConnector createHttpsConnector(String var1, HttpsSettings var2, JettySettings var3, NetworkTrafficListener var4);

    protected MultipartRequestConfigElementBuilder buildMultipartRequestConfigurer() {
        return new DefaultMultipartRequestConfigElementBuilder();
    }

    private static class NetworkTrafficListenerAdapter
    implements NetworkTrafficListener {
        private final WiremockNetworkTrafficListener wiremockNetworkTrafficListener;

        NetworkTrafficListenerAdapter(WiremockNetworkTrafficListener wiremockNetworkTrafficListener) {
            this.wiremockNetworkTrafficListener = wiremockNetworkTrafficListener;
        }

        public void opened(Socket socket) {
            this.wiremockNetworkTrafficListener.opened(socket);
        }

        public void incoming(Socket socket, ByteBuffer bytes) {
            this.wiremockNetworkTrafficListener.incoming(socket, bytes);
        }

        public void outgoing(Socket socket, ByteBuffer bytes) {
            this.wiremockNetworkTrafficListener.outgoing(socket, bytes);
        }

        public void closed(Socket socket) {
            this.wiremockNetworkTrafficListener.closed(socket);
        }
    }
}

