/*
 * Decompiled with CFR 0.152.
 */
package org.wiremock.spring.internal;

import com.github.tomakehurst.wiremock.WireMockServer;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.test.context.ContextCustomizer;
import org.springframework.test.context.MergedContextConfiguration;
import org.wiremock.spring.ConfigureWireMock;
import org.wiremock.spring.internal.Store;
import org.wiremock.spring.internal.WireMockPortResolver;
import org.wiremock.spring.internal.WireMockServerCreator;
import org.wiremock.spring.internal.WireMockTestExecutionListener;

public class WireMockContextCustomizer
implements ContextCustomizer {
    private static final Logger LOGGER = LoggerFactory.getLogger(WireMockContextCustomizer.class);
    private final List<ConfigureWireMock> configuration;

    public WireMockContextCustomizer(List<ConfigureWireMock> configurations) {
        this.configuration = configurations;
    }

    public WireMockContextCustomizer(ConfigureWireMock ... configurations) {
        this(Arrays.asList(configurations));
    }

    public void customizeContext(ConfigurableApplicationContext context, MergedContextConfiguration mergedConfig) {
        for (ConfigureWireMock configureWiremock : this.configuration) {
            this.resolveOrCreateWireMockServer(context, configureWiremock);
        }
        WireMockPortResolver portResolver = new WireMockPortResolver(context.getEnvironment());
        boolean isDirty = portResolver.anyStaticPortWithDirtySpringContext(this.configuration);
        if (isDirty) {
            LOGGER.info("Will force dirty context because of static port");
            WireMockTestExecutionListener.markContextAsDirty();
        }
    }

    private void resolveOrCreateWireMockServer(ConfigurableApplicationContext context, ConfigureWireMock options) {
        WireMockServer wireMockServer = Store.INSTANCE.findWireMockInstance((ApplicationContext)context, options.name());
        if (wireMockServer == null) {
            new WireMockServerCreator(options.name()).createWireMockServer(context, options);
        } else {
            LOGGER.info("WireMockServer with name '{}' is already configured", (Object)options.name());
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WireMockContextCustomizer that = (WireMockContextCustomizer)o;
        return Objects.equals(this.configuration, that.configuration);
    }

    public int hashCode() {
        return Objects.hash(this.configuration);
    }
}

