/*
 * Decompiled with CFR 0.152.
 */
package org.wiremock.spring.internal;

import com.github.tomakehurst.wiremock.WireMockServer;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.List;
import java.util.function.Function;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.ParameterContext;
import org.junit.jupiter.api.extension.ParameterResolver;
import org.junit.platform.commons.support.AnnotationSupport;
import org.wiremock.spring.InjectWireMock;
import org.wiremock.spring.internal.Store;

public class WireMockSpringExtension
implements BeforeEachCallback,
ParameterResolver {
    public void beforeEach(ExtensionContext extensionContext) throws Exception {
        Store.INSTANCE.findAllInstances(extensionContext).forEach(WireMockServer::resetAll);
        WireMockSpringExtension.injectWireMockInstances(extensionContext, InjectWireMock.class, InjectWireMock::value);
    }

    private static <T extends Annotation> void injectWireMockInstances(ExtensionContext extensionContext, Class<T> annotation, Function<T, String> fn) throws IllegalAccessException {
        for (Object testInstance : extensionContext.getRequiredTestInstances().getAllInstances()) {
            List annotatedFields = AnnotationSupport.findAnnotatedFields(testInstance.getClass(), annotation);
            for (Field annotatedField : annotatedFields) {
                T annotationValue = annotatedField.getAnnotation(annotation);
                annotatedField.setAccessible(true);
                WireMockServer wiremock = Store.INSTANCE.findRequiredWireMockInstance(extensionContext, fn.apply(annotationValue));
                annotatedField.set(testInstance, wiremock);
            }
        }
    }

    public boolean supportsParameter(ParameterContext parameterContext, ExtensionContext extensionContext) {
        return parameterContext.getParameter().getType() == WireMockServer.class && parameterContext.isAnnotated(InjectWireMock.class);
    }

    public Object resolveParameter(ParameterContext parameterContext, ExtensionContext extensionContext) {
        String wireMockServerName = ((InjectWireMock)parameterContext.findAnnotation(InjectWireMock.class).get()).value();
        return Store.INSTANCE.findRequiredWireMockInstance(extensionContext, wireMockServerName);
    }
}

