/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.naming.java.permission;

import java.security.Permission;
import java.security.PermissionCollection;
import java.util.Iterator;
import org.jboss.as.naming.logging.NamingLogger;
import org.wildfly.common.Assert;
import org.wildfly.naming.java.permission.JndiPermissionCollection;
import org.wildfly.naming.java.permission.JndiPermissionNameParser;
import org.wildfly.naming.java.permission.SerializedJndiPermission;

public final class JndiPermission
extends Permission {
    private static final long serialVersionUID = 1272655825146515997L;
    private final int actionBits;
    private String actionString;
    public static final int ACTION_BIND = 1;
    public static final int ACTION_REBIND = 2;
    public static final int ACTION_UNBIND = 4;
    public static final int ACTION_LOOKUP = 8;
    public static final int ACTION_LIST = 16;
    public static final int ACTION_LIST_BINDINGS = 32;
    public static final int ACTION_CREATE_SUBCONTEXT = 64;
    public static final int ACTION_DESTROY_SUBCONTEXT = 128;
    public static final int ACTION_ADD_NAMING_LISTENER = 256;
    public static final int ACTION_ALL = 511;

    public JndiPermission(String name, String actions) {
        this(name, JndiPermission.parseActions((String)Assert.checkNotNullParam((String)"actions", (Object)actions)));
    }

    public JndiPermission(String name, int actionBits) {
        super(JndiPermission.canonicalize1((String)Assert.checkNotNullParam((String)"name", (Object)name)));
        this.actionBits = actionBits & 0x1FF;
    }

    @Override
    public boolean implies(Permission permission) {
        return permission instanceof JndiPermission && this.implies((JndiPermission)permission);
    }

    public boolean implies(JndiPermission permission) {
        return permission != null && (this.actionBits & permission.actionBits) == permission.actionBits && this.impliesPath(permission.getName());
    }

    public boolean implies(String name, String actions) {
        return this.implies(name, JndiPermission.parseActions(actions));
    }

    public boolean implies(String name, int actionBits) {
        Assert.checkNotNullParam((String)"name", (Object)name);
        int maskedBits = actionBits & 0x1FF;
        return (this.actionBits & maskedBits) == maskedBits && this.impliesPath(name);
    }

    @Override
    public boolean equals(Object other) {
        return other instanceof JndiPermission && this.equals((JndiPermission)other);
    }

    public boolean equals(JndiPermission other) {
        return this == other || other != null && this.getName().equals(other.getName()) && this.actionBits == other.actionBits;
    }

    @Override
    public int hashCode() {
        return this.actionBits * 23 + this.getName().hashCode();
    }

    @Override
    public String getActions() {
        String actionString = this.actionString;
        if (actionString != null) {
            return actionString;
        }
        int actionBits = this.actionBits;
        if (actionBits == 511) {
            this.actionString = "*";
            return "*";
        }
        int m = Integer.lowestOneBit(actionBits);
        if (m != 0) {
            StringBuilder b = new StringBuilder();
            b.append(this.getAction(m));
            actionBits &= ~m;
            while (actionBits != 0) {
                m = Integer.lowestOneBit(actionBits);
                b.append(',').append(this.getAction(m));
                actionBits &= ~m;
            }
            this.actionString = b.toString();
            return this.actionString;
        }
        this.actionString = "";
        return "";
    }

    public int getActionBits() {
        return this.actionBits;
    }

    public JndiPermission withNewActions(int actionBits) {
        if ((actionBits &= 0x1FF) == this.actionBits) {
            return this;
        }
        return new JndiPermission(this.getName(), actionBits);
    }

    public JndiPermission withNewActions(String actions) {
        return this.withNewActions(JndiPermission.parseActions((String)Assert.checkNotNullParam((String)"actions", (Object)actions)));
    }

    public JndiPermission withActions(int actionBits) {
        return this.withNewActions(actionBits & 0x1FF | this.actionBits);
    }

    public JndiPermission withActions(String actions) {
        return this.withActions(JndiPermission.parseActions((String)Assert.checkNotNullParam((String)"actions", (Object)actions)));
    }

    public JndiPermission withoutActions(int actionBits) {
        return this.withNewActions(this.actionBits & ~(actionBits & 0x1FF));
    }

    public JndiPermission withoutActions(String actions) {
        return this.withoutActions(JndiPermission.parseActions((String)Assert.checkNotNullParam((String)"actions", (Object)actions)));
    }

    @Override
    public PermissionCollection newPermissionCollection() {
        return new JndiPermissionCollection();
    }

    Object writeReplace() {
        return new SerializedJndiPermission(this.getName(), this.getActions());
    }

    boolean impliesPath(String yourName) {
        return yourName.startsWith("java:") ? this.impliesPath0(yourName.substring(5)) : this.impliesPath0(yourName);
    }

    private boolean impliesPath0(String yourName) {
        Iterator<String> yourIter;
        block4: {
            String myName = this.getName();
            Iterator<String> myIter = JndiPermissionNameParser.nameIterator(myName);
            yourIter = JndiPermissionNameParser.nameIterator(yourName);
            assert (myIter.hasNext() && yourIter.hasNext());
            do {
                String myNext = myIter.next();
                String yourNext = yourIter.next();
                if (myNext.equals("-")) {
                    return true;
                }
                if (!myNext.equals("*") && !myNext.equals(yourNext)) {
                    return false;
                }
                if (!myIter.hasNext()) break block4;
            } while (yourIter.hasNext());
            return false;
        }
        return !yourIter.hasNext();
    }

    private static String canonicalize1(String name) {
        Assert.checkNotNullParam((String)"name", (Object)name);
        return name.equalsIgnoreCase("<<ALL BINDINGS>>") ? "-" : JndiPermission.canonicalize2(name);
    }

    private static String canonicalize2(String name) {
        return name.startsWith("java:") ? name.substring(5) : name;
    }

    private static int parseActions(String actionsString) {
        int actions = 0;
        int pos = 0;
        int idx = actionsString.indexOf(44);
        while (true) {
            String str;
            if (idx == -1) {
                str = actionsString.substring(pos).trim();
                if (!str.isEmpty()) {
                    actions |= JndiPermission.parseAction(str);
                }
                return actions;
            }
            str = actionsString.substring(pos, idx).trim();
            pos = idx + 1;
            if (!str.isEmpty()) {
                actions |= JndiPermission.parseAction(str);
            }
            idx = actionsString.indexOf(44, pos);
        }
    }

    private static int parseAction(String str) {
        switch (str) {
            case "*": 
            case "all": {
                return 511;
            }
            case "bind": {
                return 1;
            }
            case "rebind": {
                return 2;
            }
            case "unbind": {
                return 4;
            }
            case "lookup": {
                return 8;
            }
            case "list": {
                return 16;
            }
            case "listBindings": {
                return 32;
            }
            case "createSubcontext": {
                return 64;
            }
            case "destroySubcontext": {
                return 128;
            }
            case "addNamingListener": {
                return 256;
            }
        }
        throw NamingLogger.ROOT_LOGGER.invalidPermissionAction(str);
    }

    private String getAction(int bit) {
        switch (bit) {
            case 1: {
                return "bind";
            }
            case 2: {
                return "rebind";
            }
            case 4: {
                return "unbind";
            }
            case 8: {
                return "lookup";
            }
            case 16: {
                return "list";
            }
            case 32: {
                return "listBindings";
            }
            case 64: {
                return "createSubcontext";
            }
            case 128: {
                return "destroySubcontext";
            }
            case 256: {
                return "addNamingListener";
            }
        }
        throw Assert.impossibleSwitchCase((int)bit);
    }
}

