/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.connector.services.workmanager.statistics;

import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import org.jboss.as.connector.dynamicresource.ClearWorkManagerStatisticsHandler;
import org.jboss.as.connector.subsystems.resourceadapters.CommonAttributes;
import org.jboss.as.connector.subsystems.resourceadapters.Constants;
import org.jboss.as.connector.subsystems.resourceadapters.WorkManagerRuntimeAttributeReadHandler;
import org.jboss.as.connector.subsystems.resourceadapters.WorkManagerRuntimeAttributeWriteHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ResourceBuilder;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.descriptions.OverrideDescriptionProvider;
import org.jboss.as.controller.descriptions.StandardResourceDescriptionResolver;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.dmr.ModelNode;
import org.jboss.jca.core.api.workmanager.WorkManager;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;

public class WorkManagerStatisticsService
implements Service<ManagementResourceRegistration> {
    private final ManagementResourceRegistration overrideRegistration;
    private final boolean statsEnabled;
    protected final InjectedValue<WorkManager> workManager = new InjectedValue();

    public WorkManagerStatisticsService(ManagementResourceRegistration registration, String name, boolean statsEnabled) {
        this.overrideRegistration = registration.isAllowsOverride() ? registration.registerOverrideModel(name, new OverrideDescriptionProvider(){

            public Map<String, ModelNode> getAttributeOverrideDescriptions(Locale locale) {
                return Collections.emptyMap();
            }

            public Map<String, ModelNode> getChildTypeOverrideDescriptions(Locale locale) {
                return Collections.emptyMap();
            }
        }) : registration;
        this.statsEnabled = statsEnabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(StartContext context) throws StartException {
        WorkManagerStatisticsService workManagerStatisticsService = this;
        synchronized (workManagerStatisticsService) {
            WorkManager wm = (WorkManager)this.workManager.getValue();
            wm.setStatisticsEnabled(this.statsEnabled);
            if (wm.getStatistics() != null) {
                PathElement peLocaldWm = PathElement.pathElement((String)"statistics", (String)"local");
                ResourceBuilder resourceBuilder = ResourceBuilder.Factory.create((PathElement)peLocaldWm, (StandardResourceDescriptionResolver)new StandardResourceDescriptionResolver("statistics.workmanager", CommonAttributes.RESOURCE_NAME, CommonAttributes.class.getClassLoader()));
                ManagementResourceRegistration wmSubRegistration = this.overrideRegistration.registerSubModel(resourceBuilder.build());
                WorkManagerRuntimeAttributeReadHandler metricHandler = new WorkManagerRuntimeAttributeReadHandler(wm, wm.getStatistics(), false);
                for (SimpleAttributeDefinition metric : Constants.WORKMANAGER_METRICS) {
                    wmSubRegistration.registerMetric((AttributeDefinition)metric, (OperationStepHandler)metricHandler);
                }
                WorkManagerRuntimeAttributeReadHandler readHandler = new WorkManagerRuntimeAttributeReadHandler(wm, wm.getStatistics(), false);
                WorkManagerRuntimeAttributeWriteHandler writeHandler = new WorkManagerRuntimeAttributeWriteHandler(wm, false, (AttributeDefinition[])Constants.WORKMANAGER_RW_ATTRIBUTES);
                for (SimpleAttributeDefinition attribute : Constants.WORKMANAGER_RW_ATTRIBUTES) {
                    wmSubRegistration.registerReadWriteAttribute((AttributeDefinition)attribute, (OperationStepHandler)readHandler, (OperationStepHandler)writeHandler);
                }
                wmSubRegistration.registerOperationHandler(ClearWorkManagerStatisticsHandler.DEFINITION, (OperationStepHandler)new ClearWorkManagerStatisticsHandler(wm));
            }
        }
    }

    public void stop(StopContext context) {
        PathElement peLocaldWm = PathElement.pathElement((String)"statistics", (String)"local");
        if (this.overrideRegistration.getSubModel(PathAddress.pathAddress((PathElement[])new PathElement[]{peLocaldWm})) != null) {
            this.overrideRegistration.unregisterSubModel(peLocaldWm);
        }
    }

    public ManagementResourceRegistration getValue() throws IllegalStateException, IllegalArgumentException {
        return this.overrideRegistration;
    }

    public Injector<WorkManager> getWorkManagerInjector() {
        return this.workManager;
    }
}

