/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.connector.metadata.api.resourceadapter;

import java.util.ArrayList;
import java.util.List;
import org.jboss.as.connector.metadata.api.resourceadapter.WorkManagerSecurity;
import org.jboss.jca.common.api.metadata.common.Credential;
import org.jboss.jca.common.api.metadata.common.Security;
import org.jboss.jca.common.api.metadata.common.SecurityMetadata;
import org.jboss.jca.common.api.metadata.resourceadapter.Activation;
import org.jboss.jca.common.api.metadata.resourceadapter.ConnectionDefinition;

public final class ActivationSecurityUtil {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isLegacySecurityRequired(Activation raxml) {
        List connDefs;
        boolean required = ActivationSecurityUtil.isWorkManagerLegacySecurityRequired(raxml);
        if (!required && (connDefs = raxml.getConnectionDefinitions()) != null) {
            ArrayList clonedDefs;
            Activation activation = raxml;
            synchronized (activation) {
                clonedDefs = new ArrayList(connDefs);
            }
            for (ConnectionDefinition cd : clonedDefs) {
                if (!ActivationSecurityUtil.isConnectionDefinitionLegacySecurityRequired(cd)) continue;
                required = true;
                break;
            }
        }
        return required;
    }

    public static boolean isWorkManagerLegacySecurityRequired(Activation raxml) {
        org.jboss.jca.common.api.metadata.resourceadapter.WorkManagerSecurity wmsecurity = raxml.getWorkManager() != null ? raxml.getWorkManager().getSecurity() : null;
        return ActivationSecurityUtil.isLegacySecurityRequired(wmsecurity);
    }

    public static boolean isConnectionDefinitionLegacySecurityRequired(ConnectionDefinition cd) {
        Security cdSecurity = cd.getSecurity();
        Credential cdRecoveryCredential = cd.getRecovery() == null ? null : cd.getRecovery().getCredential();
        return ActivationSecurityUtil.isLegacySecurityRequired((SecurityMetadata)cdSecurity) || ActivationSecurityUtil.isLegacySecurityRequired((SecurityMetadata)cdRecoveryCredential);
    }

    public static boolean isLegacySecurityRequired(SecurityMetadata security) {
        if (security == null) {
            return false;
        }
        if (security instanceof org.jboss.as.connector.metadata.api.common.SecurityMetadata && ((org.jboss.as.connector.metadata.api.common.SecurityMetadata)security).isElytronEnabled()) {
            return false;
        }
        String domain = security.resolveSecurityDomain();
        return domain != null && domain.trim().length() > 0;
    }

    private static boolean isLegacySecurityRequired(org.jboss.jca.common.api.metadata.resourceadapter.WorkManagerSecurity config) {
        if (config == null) {
            return false;
        }
        if (config instanceof WorkManagerSecurity && ((WorkManagerSecurity)config).isElytronEnabled()) {
            return false;
        }
        String domain = config.getDomain();
        return domain != null && domain.trim().length() > 0;
    }

    private ActivationSecurityUtil() {
    }
}

