/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.transaction.client;

import jakarta.transaction.RollbackException;
import jakarta.transaction.SystemException;
import java.io.Serializable;
import java.net.URI;
import java.security.PrivilegedActionException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import org.wildfly.common.Assert;
import org.wildfly.common.annotation.NotNull;
import org.wildfly.security.auth.client.AuthenticationContext;
import org.wildfly.transaction.client.OutflowHandleManager;
import org.wildfly.transaction.client.RemoteTransactionContext;
import org.wildfly.transaction.client.SerializedXAResource;
import org.wildfly.transaction.client.SimpleXid;
import org.wildfly.transaction.client.XAOutflowHandle;
import org.wildfly.transaction.client.XARecoverable;
import org.wildfly.transaction.client.XAResourceRegistry;
import org.wildfly.transaction.client.XAResourceRegistryProviderHolder;
import org.wildfly.transaction.client._private.Log;
import org.wildfly.transaction.client.spi.RemoteTransactionPeer;
import org.wildfly.transaction.client.spi.RemoteTransactionProvider;
import org.wildfly.transaction.client.spi.SubordinateTransactionControl;

final class SubordinateXAResource
implements XAResource,
XARecoverable,
Serializable {
    private static final long serialVersionUID = 444691792601946632L;
    private final URI location;
    private final String parentName;
    private final XAResourceRegistry resourceRegistry;
    private final AuthenticationContext authenticationContext;
    private volatile int timeout = 300;
    private long startTime = 0L;
    private volatile Xid xid;
    private int capturedTimeout;
    private final AtomicInteger stateRef = new AtomicInteger(0);

    SubordinateXAResource(URI location, String parentName, XAResourceRegistry recoveryRegistry) {
        this.location = location;
        this.parentName = parentName;
        this.resourceRegistry = recoveryRegistry;
        this.authenticationContext = AuthenticationContext.captureCurrent();
    }

    SubordinateXAResource(URI location, String parentName, Xid xid, int flags, XAResourceRegistry recoveryRegistry) {
        this(location, parentName, recoveryRegistry);
        this.xid = xid;
        this.stateRef.set(flags);
    }

    SubordinateXAResource(URI location, int flags, String parentName) {
        this.location = location;
        this.parentName = parentName;
        this.stateRef.set(flags);
        this.resourceRegistry = null;
        this.authenticationContext = AuthenticationContext.captureCurrent();
    }

    Xid getXid() {
        return this.xid;
    }

    XAOutflowHandle addHandle(final Xid xid) {
        if (!OutflowHandleManager.open(this.stateRef)) {
            throw Log.log.invalidTxnState();
        }
        return new XAOutflowHandle(){
            private final AtomicBoolean done = new AtomicBoolean();

            @Override
            @NotNull
            public Xid getXid() {
                return xid;
            }

            @Override
            public int getRemainingTime() {
                return SubordinateXAResource.this.getRemainingTime();
            }

            @Override
            public void forgetEnlistment() {
                if (!this.done.compareAndSet(false, true)) {
                    throw Log.log.alreadyForgotten();
                }
                OutflowHandleManager.forgetOne(SubordinateXAResource.this.stateRef);
            }

            @Override
            public void nonMasterEnlistment() {
                if (!this.done.compareAndSet(false, true)) {
                    throw Log.log.alreadyForgotten();
                }
                OutflowHandleManager.nonMasterOne(SubordinateXAResource.this.stateRef);
            }

            @Override
            public void verifyEnlistment() throws RollbackException, SystemException {
                if (!this.done.compareAndSet(false, true)) {
                    throw Log.log.alreadyEnlisted();
                }
                OutflowHandleManager.verifyOne(SubordinateXAResource.this.stateRef);
            }
        };
    }

    boolean commitToEnlistment() {
        return OutflowHandleManager.commit(this.stateRef);
    }

    @Override
    public void start(Xid xid, int flags) throws XAException {
        if (flags == 0x200000) {
            throw Assert.unreachableCode();
        }
        this.startTime = System.nanoTime();
        this.capturedTimeout = this.timeout;
        this.lookup(xid);
        this.xid = xid;
        if (this.resourceRegistry != null) {
            try {
                this.resourceRegistry.addResource(this, xid, this.location);
            }
            catch (SystemException se) {
                XAException xaException = new XAException(Log.log.failedToAddXAResourceToRegistry(this, xid, this.location));
                xaException.errorCode = -3;
                xaException.addSuppressed(se);
                throw xaException;
            }
        }
    }

    @Override
    public void end(Xid xid, int flags) throws XAException {
        if (flags == 0x4000000 || flags == 0x20000000) {
            this.lookup(xid).end(flags);
        }
    }

    public void beforeCompletion(Xid xid) throws XAException {
        if (this.commitToEnlistment()) {
            this.lookup(xid).beforeCompletion();
        }
    }

    @Override
    public int prepare(Xid xid) throws XAException {
        int result;
        try {
            result = this.commitToEnlistment() ? this.lookup(xid).prepare() : 3;
        }
        catch (RuntimeException | XAException exception) {
            if (this.resourceRegistry != null) {
                this.resourceRegistry.resourceInDoubt(this);
            }
            throw exception;
        }
        if (this.resourceRegistry != null && result == 3) {
            this.resourceRegistry.removeResource(this);
        }
        return result;
    }

    @Override
    public void commit(Xid xid, boolean onePhase) throws XAException {
        try {
            if (this.commitToEnlistment()) {
                this.lookup(xid).commit(onePhase);
            }
        }
        catch (RuntimeException | XAException exception) {
            if (this.resourceRegistry != null) {
                this.resourceRegistry.resourceInDoubt(this);
            }
            throw exception;
        }
        if (this.resourceRegistry != null) {
            this.resourceRegistry.removeResource(this);
        } else {
            for (XAResource xares : XAResourceRegistryProviderHolder.getInstance().getInDoubtXAResources()) {
                if (!(xares instanceof SubordinateXAResource)) continue;
                SubordinateXAResource subordinateXares = (SubordinateXAResource)xares;
                if (!SimpleXid.of(xid).equals(SimpleXid.of(subordinateXares.xid))) continue;
                subordinateXares.resourceRegistry.removeResource(subordinateXares);
            }
        }
    }

    @Override
    public void rollback(Xid xid) throws XAException {
        try {
            if (this.commitToEnlistment()) {
                this.lookup(xid).rollback();
            }
        }
        catch (RuntimeException | XAException e) {
            if (this.resourceRegistry != null) {
                this.resourceRegistry.resourceInDoubt(this);
            }
            throw e;
        }
        if (this.resourceRegistry != null) {
            this.resourceRegistry.removeResource(this);
        }
    }

    @Override
    public void forget(Xid xid) throws XAException {
        if (this.commitToEnlistment()) {
            this.lookup(xid).forget();
        }
    }

    private SubordinateTransactionControl lookup(Xid xid) throws XAException {
        return this.getRemoteTransactionPeer().lookupXid(xid);
    }

    private RemoteTransactionProvider getProvider() {
        RemoteTransactionProvider provider = RemoteTransactionContext.getInstancePrivate().getProvider(this.location);
        if (provider == null) {
            throw Log.log.noProviderForUri(this.location);
        }
        return provider;
    }

    @Override
    public Xid[] recover(int flag) throws XAException {
        return this.recover(flag, this.parentName);
    }

    @Override
    public Xid[] recover(int flag, String parentName) throws XAException {
        Xid[] recoveredXids = this.getRemoteTransactionPeer().recover(flag, parentName);
        if ((flag & 0x1000000) == 0x1000000 && recoveredXids.length == 0 && this.resourceRegistry != null) {
            this.resourceRegistry.removeResource(this);
        }
        return recoveredXids;
    }

    private RemoteTransactionPeer getRemoteTransactionPeer() throws XAException {
        try {
            return this.authenticationContext.run(() -> this.getProvider().getPeerHandleForXa(this.location, null, null));
        }
        catch (PrivilegedActionException e) {
            Throwable cause = e.getCause();
            if (cause instanceof XAException) {
                throw (XAException)cause;
            }
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean isSameRM(XAResource xaRes) throws XAException {
        return xaRes instanceof SubordinateXAResource && this.location.equals(((SubordinateXAResource)xaRes).location);
    }

    @Override
    public int getTransactionTimeout() {
        return this.timeout;
    }

    @Override
    public boolean setTransactionTimeout(int seconds) throws XAException {
        if (seconds < 0) {
            throw Log.log.negativeTxnTimeoutXa(-5);
        }
        this.timeout = seconds == 0 ? 300 : seconds;
        return true;
    }

    Object writeReplace() {
        return new SerializedXAResource(this.location, this.parentName);
    }

    public String toString() {
        return Log.log.subordinateXaResource(this.location);
    }

    int getRemainingTime() {
        long elapsed = Math.max(0L, System.nanoTime() - this.startTime);
        int capturedTimeout = this.capturedTimeout;
        return capturedTimeout - (int)Math.min((long)capturedTimeout, elapsed / 1000000000L);
    }
}

