/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.sasl.plain;

import java.util.Collections;
import java.util.Map;
import javax.security.auth.callback.CallbackHandler;
import javax.security.sasl.SaslClient;
import javax.security.sasl.SaslClientFactory;
import javax.security.sasl.SaslException;
import org.wildfly.common.Assert;
import org.wildfly.security.sasl.WildFlySasl;
import org.wildfly.security.sasl.plain.PlainSasl;
import org.wildfly.security.sasl.plain.PlainSaslClient;

public final class PlainSaslClientFactory
implements SaslClientFactory {
    @Override
    public SaslClient createSaslClient(String[] mechanisms, String authorizationId, String protocol, String serverName, Map<String, ?> props, CallbackHandler cbh) throws SaslException {
        Assert.checkNotNullParam("cbh", cbh);
        if (props == null) {
            props = Collections.emptyMap();
        }
        if (PlainSasl.isMatched(props, false)) {
            for (String mechanism : mechanisms) {
                if (!"PLAIN".equals(mechanism)) continue;
                boolean skipNormalization = props.containsKey("org.wildfly.sasl.skip-normalization") ? Boolean.parseBoolean((String)props.get("org.wildfly.sasl.skip-normalization")) : false;
                return new PlainSaslClient(authorizationId, cbh, skipNormalization);
            }
        }
        return null;
    }

    @Override
    public String[] getMechanismNames(Map<String, ?> props) {
        return PlainSasl.isMatched(props, true) ? (String[])PlainSasl.NAMES.clone() : WildFlySasl.NO_NAMES;
    }
}

