/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.sasl.anonymous;

import java.nio.charset.StandardCharsets;
import javax.security.auth.callback.CallbackHandler;
import javax.security.sasl.SaslException;
import org.wildfly.common.Assert;
import org.wildfly.security.auth.callback.AnonymousAuthorizationCallback;
import org.wildfly.security.mechanism._private.ElytronMessages;
import org.wildfly.security.sasl.util.AbstractSaslServer;

public final class AnonymousSaslServer
extends AbstractSaslServer {
    private static final int INITIAL_STATE = 1;

    AnonymousSaslServer(String protocol, String serverName, CallbackHandler callbackHandler) {
        super("ANONYMOUS", protocol, serverName, callbackHandler, ElytronMessages.saslAnonymous);
        this.setNegotiationState(1);
    }

    @Override
    public String getAuthorizationID() {
        return "anonymous";
    }

    @Override
    protected byte[] evaluateMessage(int state, byte[] message) throws SaslException {
        switch (state) {
            case 1: {
                int length = message.length;
                if (length == 0) {
                    return NO_BYTES;
                }
                if (length > 1020) {
                    throw ElytronMessages.saslAnonymous.mechAuthenticationNameTooLong().toSaslException();
                }
                String name = new String(message, StandardCharsets.UTF_8);
                if (name.length() > 255) {
                    throw ElytronMessages.saslAnonymous.mechAuthenticationNameTooLong().toSaslException();
                }
                AnonymousAuthorizationCallback callback = new AnonymousAuthorizationCallback(name);
                this.handleCallbacks(callback);
                if (!callback.isAuthorized()) {
                    throw ElytronMessages.saslAnonymous.mechAnonymousAuthorizationDenied().toSaslException();
                }
                this.negotiationComplete();
                return null;
            }
        }
        throw Assert.impossibleSwitchCase(state);
    }
}

