/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.util;

import java.util.List;
import java.util.Objects;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;

public class LazyRemovalList<T> {
    private final Queue<Entry<T>> list = new ConcurrentLinkedQueue<Entry<T>>();
    private final int max_elements;
    private final long max_age;

    public LazyRemovalList() {
        this(200, 5000L);
    }

    public LazyRemovalList(int max_elements, long max_age) {
        this.max_elements = max_elements;
        this.max_age = TimeUnit.NANOSECONDS.convert(max_age, TimeUnit.MILLISECONDS);
    }

    public boolean add(T val) {
        boolean rc = this.list.add(new Entry<T>(Objects.requireNonNull(val)));
        if (rc) {
            this.checkMaxSizeExceeded();
        }
        return rc;
    }

    public T get(T val) {
        if (val == null) {
            return null;
        }
        return this.list.stream().map(e -> e.val).filter(v -> v.equals(val)).findFirst().orElse(null);
    }

    public void forEach(Consumer<T> c) {
        if (c == null) {
            return;
        }
        for (Entry entry : this.list) {
            try {
                if (entry.removable) continue;
                c.accept(entry.val);
            }
            catch (Throwable throwable) {}
        }
    }

    public void remove(T val) {
        if (val == null) {
            return;
        }
        for (Entry entry : this.list) {
            if (!entry.val.equals(val)) continue;
            entry.removable(true);
            break;
        }
    }

    public void clear(boolean force) {
        if (force) {
            this.list.clear();
        } else {
            this.list.forEach((? super T e) -> e.removable(true));
        }
    }

    public List<T> nonRemovedValues() {
        return this.list.stream().filter(e -> !e.removable).map(e -> e.val).collect(Collectors.toList());
    }

    public int size() {
        return this.list.size();
    }

    public String printCache() {
        return this.list.stream().map(Entry::toString).collect(Collectors.joining("\n"));
    }

    public String printCache(Printable<T> print_function) {
        return this.list.stream().map(print_function::print).collect(Collectors.joining("\n"));
    }

    public String toString() {
        return this.printCache();
    }

    private void checkMaxSizeExceeded() {
        if (this.list.size() > this.max_elements) {
            this.removeMarkedElements(false);
        }
    }

    public void removeMarkedElements(boolean force) {
        long curr_time = System.nanoTime();
        this.list.removeIf(e -> e.removable && (force || curr_time - e.timestamp >= this.max_age));
    }

    public void removeMarkedElements() {
        this.removeMarkedElements(false);
    }

    public static class Entry<T> {
        protected final T val;
        protected long timestamp = System.nanoTime();
        protected boolean removable = false;

        public Entry(T val) {
            this.val = val;
        }

        public boolean removable() {
            return this.removable;
        }

        public Entry<T> removable(boolean flag) {
            if (this.removable != flag) {
                this.removable = flag;
                this.timestamp = System.nanoTime();
            }
            return this;
        }

        public T val() {
            return this.val;
        }

        public String toString() {
            return this.toString(null);
        }

        public String toString(Function<T, String> print_val) {
            StringBuilder sb = new StringBuilder(print_val != null ? print_val.apply(this.val) : this.val.toString()).append(" (");
            long age = TimeUnit.MILLISECONDS.convert(System.nanoTime() - this.timestamp, TimeUnit.NANOSECONDS);
            if (age < 1000L) {
                sb.append(age).append(" ms");
            } else {
                sb.append(TimeUnit.SECONDS.convert(age, TimeUnit.MILLISECONDS)).append(" secs");
            }
            sb.append(" old").append(this.removable ? ", removable" : "").append(")");
            return sb.toString();
        }
    }

    public static interface Printable<T> {
        public String print(Entry<T> var1);
    }
}

