/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.api.core;

import io.netty.buffer.ByteBuf;
import java.io.InputStream;
import java.util.Map;
import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.core.message.LargeBodyReader;
import org.apache.activemq.artemis.core.message.impl.CoreMessage;

public interface ICoreMessage
extends Message {
    public Message setBuffer(ByteBuf var1);

    public ByteBuf getBuffer();

    public LargeBodyReader getLargeBodyReader() throws ActiveMQException;

    public int getHeadersAndPropertiesEncodeSize();

    @Override
    public InputStream getBodyInputStream();

    public ActiveMQBuffer getReadOnlyBodyBuffer();

    public int getBodyBufferSize();

    public ActiveMQBuffer getDataBuffer();

    @Override
    public byte getType();

    @Override
    public CoreMessage setType(byte var1);

    public boolean isServerMessage();

    @Override
    public ActiveMQBuffer getBodyBuffer();

    public int getEndOfBodyPosition();

    public void moveHeadersAndProperties(Message var1);

    public void sendBuffer_1X(ByteBuf var1);

    public void receiveBuffer_1X(ByteBuf var1);

    @Override
    default public Map<String, Object> toMap(int valueSizeLimit) {
        Map<String, Object> map = this.toPropertyMap(valueSizeLimit);
        map.put("messageID", this.getMessageID());
        Object userID = this.getUserID();
        if (this.getUserID() != null) {
            map.put("userID", "ID:" + userID.toString());
        }
        map.put("address", this.getAddress() == null ? "" : this.getAddress());
        map.put("type", this.getType());
        map.put("durable", this.isDurable());
        map.put("expiration", this.getExpiration());
        map.put("timestamp", this.getTimestamp());
        map.put("priority", this.getPriority());
        return map;
    }

    default public boolean isConfirmed() {
        return false;
    }

    default public void setConfirmed(boolean confirmed) {
    }
}

