/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.remoting.impl.netty;

import io.netty.bootstrap.Bootstrap;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.ChannelPromise;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.channel.WriteBufferWaterMark;
import io.netty.channel.epoll.EpollEventLoopGroup;
import io.netty.channel.epoll.EpollSocketChannel;
import io.netty.channel.group.ChannelGroup;
import io.netty.channel.group.DefaultChannelGroup;
import io.netty.channel.kqueue.KQueueEventLoopGroup;
import io.netty.channel.kqueue.KQueueSocketChannel;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.codec.base64.Base64;
import io.netty.handler.codec.http.DefaultFullHttpRequest;
import io.netty.handler.codec.http.DefaultHttpRequest;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpClientCodec;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpObject;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.HttpRequestEncoder;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseDecoder;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.handler.codec.http.cookie.ClientCookieDecoder;
import io.netty.handler.codec.http.cookie.Cookie;
import io.netty.handler.codec.socksx.SocksVersion;
import io.netty.handler.proxy.ProxyHandler;
import io.netty.handler.proxy.Socks4ProxyHandler;
import io.netty.handler.proxy.Socks5ProxyHandler;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslHandler;
import io.netty.resolver.NoopAddressResolverGroup;
import io.netty.util.AttributeKey;
import io.netty.util.ResourceLeakDetector;
import io.netty.util.concurrent.GlobalEventExecutor;
import java.io.IOException;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.stream.Stream;
import javax.net.ssl.SNIHostName;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLParameters;
import org.apache.activemq.artemis.api.config.ActiveMQDefaultConfiguration;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.Pair;
import org.apache.activemq.artemis.core.client.ActiveMQClientLogger;
import org.apache.activemq.artemis.core.client.ActiveMQClientMessageBundle;
import org.apache.activemq.artemis.core.protocol.core.impl.ActiveMQClientProtocolManager;
import org.apache.activemq.artemis.core.remoting.impl.netty.ActiveMQChannelHandler;
import org.apache.activemq.artemis.core.remoting.impl.netty.CheckDependencies;
import org.apache.activemq.artemis.core.remoting.impl.netty.NettyConnection;
import org.apache.activemq.artemis.core.remoting.impl.netty.SharedEventLoopGroup;
import org.apache.activemq.artemis.core.remoting.impl.netty.TransportConstants;
import org.apache.activemq.artemis.core.remoting.impl.ssl.SSLSupport;
import org.apache.activemq.artemis.core.server.ActiveMQComponent;
import org.apache.activemq.artemis.spi.core.remoting.AbstractConnector;
import org.apache.activemq.artemis.spi.core.remoting.BaseConnectionLifeCycleListener;
import org.apache.activemq.artemis.spi.core.remoting.BufferHandler;
import org.apache.activemq.artemis.spi.core.remoting.ClientConnectionLifeCycleListener;
import org.apache.activemq.artemis.spi.core.remoting.ClientProtocolManager;
import org.apache.activemq.artemis.spi.core.remoting.Connection;
import org.apache.activemq.artemis.spi.core.remoting.ssl.OpenSSLContextFactoryProvider;
import org.apache.activemq.artemis.spi.core.remoting.ssl.SSLContextConfig;
import org.apache.activemq.artemis.spi.core.remoting.ssl.SSLContextFactoryProvider;
import org.apache.activemq.artemis.utils.ConfigurationHelper;
import org.apache.activemq.artemis.utils.FutureLatch;
import org.apache.activemq.artemis.utils.IPV6Util;
import org.jboss.logging.Logger;

public class NettyConnector
extends AbstractConnector {
    public static String NIO_CONNECTOR_TYPE = "NIO";
    public static String EPOLL_CONNECTOR_TYPE = "EPOLL";
    public static String KQUEUE_CONNECTOR_TYPE = "KQUEUE";
    private static final Logger logger = Logger.getLogger(NettyConnector.class);
    public static final String JAVAX_KEYSTORE_PATH_PROP_NAME = "javax.net.ssl.keyStore";
    public static final String JAVAX_KEYSTORE_PASSWORD_PROP_NAME = "javax.net.ssl.keyStorePassword";
    public static final String JAVAX_KEYSTORE_TYPE_PROP_NAME = "javax.net.ssl.keyStoreType";
    public static final String JAVAX_KEYSTORE_PROVIDER_PROP_NAME = "javax.net.ssl.keyStoreProvider";
    public static final String JAVAX_TRUSTSTORE_PATH_PROP_NAME = "javax.net.ssl.trustStore";
    public static final String JAVAX_TRUSTSTORE_PASSWORD_PROP_NAME = "javax.net.ssl.trustStorePassword";
    public static final String JAVAX_TRUSTSTORE_TYPE_PROP_NAME = "javax.net.ssl.trustStoreType";
    public static final String JAVAX_TRUSTSTORE_PROVIDER_PROP_NAME = "javax.net.ssl.trustStoreProvider";
    public static final String ACTIVEMQ_KEYSTORE_PROVIDER_PROP_NAME = "org.apache.activemq.ssl.keyStoreProvider";
    public static final String ACTIVEMQ_KEYSTORE_TYPE_PROP_NAME = "org.apache.activemq.ssl.keyStoreType";
    public static final String ACTIVEMQ_KEYSTORE_PATH_PROP_NAME = "org.apache.activemq.ssl.keyStore";
    public static final String ACTIVEMQ_KEYSTORE_PASSWORD_PROP_NAME = "org.apache.activemq.ssl.keyStorePassword";
    public static final String ACTIVEMQ_TRUSTSTORE_PROVIDER_PROP_NAME = "org.apache.activemq.ssl.trustStoreProvider";
    public static final String ACTIVEMQ_TRUSTSTORE_TYPE_PROP_NAME = "org.apache.activemq.ssl.trustStoreType";
    public static final String ACTIVEMQ_TRUSTSTORE_PATH_PROP_NAME = "org.apache.activemq.ssl.trustStore";
    public static final String ACTIVEMQ_TRUSTSTORE_PASSWORD_PROP_NAME = "org.apache.activemq.ssl.trustStorePassword";
    public static final String MAGIC_NUMBER = "CF70DEB8-70F9-4FBA-8B4F-DFC3E723B4CD";
    public static final String SEC_ACTIVEMQ_REMOTING_KEY = "Sec-ActiveMQRemoting-Key";
    public static final String SEC_ACTIVEMQ_REMOTING_ACCEPT = "Sec-ActiveMQRemoting-Accept";
    public static final String ACTIVEMQ_REMOTING = "activemq-remoting";
    private static final AttributeKey<String> REMOTING_KEY = AttributeKey.valueOf("Sec-ActiveMQRemoting-Key");
    public static final Map<String, Object> DEFAULT_CONFIG;
    private final boolean serverConnection;
    private Class<? extends Channel> channelClazz;
    private Bootstrap bootstrap;
    private ChannelGroup channelGroup;
    private final BufferHandler handler;
    private final BaseConnectionLifeCycleListener<?> listener;
    private boolean sslEnabled = false;
    private boolean httpEnabled;
    private long httpMaxClientIdleTime;
    private long httpClientIdleScanPeriod;
    private boolean httpRequiresSessionId;
    private boolean httpUpgradeEnabled;
    private boolean proxyEnabled;
    private String proxyHost;
    private int proxyPort;
    private SocksVersion proxyVersion;
    private String proxyUsername;
    private String proxyPassword;
    private boolean proxyRemoteDNS;
    private boolean useServlet;
    private String host;
    private int port;
    private String localAddress;
    private int localPort;
    private String keyStoreProvider;
    private String keyStoreType;
    private String keyStorePath;
    private String keyStorePassword;
    private String trustStoreProvider;
    private String trustStoreType;
    private String trustStorePath;
    private String trustStorePassword;
    private String crlPath;
    private String enabledCipherSuites;
    private String enabledProtocols;
    private String sslProvider;
    private String trustManagerFactoryPlugin;
    private boolean verifyHost;
    private boolean trustAll;
    private boolean forceSSLParameters;
    private String sniHost;
    private boolean useDefaultSslContext;
    private boolean tcpNoDelay;
    private int tcpSendBufferSize;
    private int tcpReceiveBufferSize;
    private final int writeBufferLowWaterMark;
    private final int writeBufferHighWaterMark;
    private long batchDelay;
    private ConcurrentMap<Object, Connection> connections = new ConcurrentHashMap<Object, Connection>();
    private String servletPath;
    private boolean useEpoll;
    private boolean useKQueue;
    private int remotingThreads;
    private boolean useGlobalWorkerPool;
    private ScheduledExecutorService scheduledThreadPool;
    private Executor closeExecutor;
    private BatchFlusher flusher;
    private ScheduledFuture<?> batchFlusherFuture;
    private EventLoopGroup group;
    private int connectTimeoutMillis;
    private final ClientProtocolManager protocolManager;

    public NettyConnector(Map<String, Object> configuration, BufferHandler handler, BaseConnectionLifeCycleListener<?> listener, Executor closeExecutor, Executor threadPool, ScheduledExecutorService scheduledThreadPool) {
        this(configuration, handler, listener, closeExecutor, threadPool, scheduledThreadPool, new ActiveMQClientProtocolManager());
    }

    public NettyConnector(Map<String, Object> configuration, BufferHandler handler, BaseConnectionLifeCycleListener<?> listener, Executor closeExecutor, Executor threadPool, ScheduledExecutorService scheduledThreadPool, ClientProtocolManager protocolManager) {
        this(configuration, handler, listener, closeExecutor, threadPool, scheduledThreadPool, protocolManager, false);
    }

    public NettyConnector(Map<String, Object> configuration, BufferHandler handler, BaseConnectionLifeCycleListener<?> listener, Executor closeExecutor, Executor threadPool, ScheduledExecutorService scheduledThreadPool, ClientProtocolManager protocolManager, boolean serverConnection) {
        super(configuration);
        this.serverConnection = serverConnection;
        this.protocolManager = protocolManager;
        if (listener == null) {
            throw ActiveMQClientMessageBundle.BUNDLE.nullListener();
        }
        if (!serverConnection && handler == null) {
            throw ActiveMQClientMessageBundle.BUNDLE.nullHandler();
        }
        this.listener = listener;
        this.handler = handler;
        this.sslEnabled = ConfigurationHelper.getBooleanProperty("sslEnabled", false, configuration);
        this.httpEnabled = ConfigurationHelper.getBooleanProperty("httpEnabled", false, configuration);
        this.servletPath = ConfigurationHelper.getStringProperty("servletPath", "/messaging/ActiveMQServlet", configuration);
        if (this.httpEnabled) {
            this.httpMaxClientIdleTime = ConfigurationHelper.getLongProperty("httpClientIdleTime", 500L, configuration);
            this.httpClientIdleScanPeriod = ConfigurationHelper.getLongProperty("httpClientIdleScanPeriod", 500L, configuration);
            this.httpRequiresSessionId = ConfigurationHelper.getBooleanProperty("httpRequiresSessionId", false, configuration);
        } else {
            this.httpMaxClientIdleTime = 0L;
            this.httpClientIdleScanPeriod = -1L;
            this.httpRequiresSessionId = false;
        }
        this.httpUpgradeEnabled = ConfigurationHelper.getBooleanProperty("httpUpgradeEnabled", false, configuration);
        this.proxyEnabled = ConfigurationHelper.getBooleanProperty("socksEnabled", false, configuration);
        if (this.proxyEnabled) {
            this.proxyHost = ConfigurationHelper.getStringProperty("socksHost", TransportConstants.DEFAULT_PROXY_HOST, configuration);
            this.proxyPort = ConfigurationHelper.getIntProperty("socksPort", 0, configuration);
            int socksVersionNumber = ConfigurationHelper.getIntProperty("socksVersion", TransportConstants.DEFAULT_PROXY_VERSION, configuration);
            this.proxyVersion = SocksVersion.valueOf((byte)socksVersionNumber);
            this.proxyUsername = ConfigurationHelper.getStringProperty("socksUsername", TransportConstants.DEFAULT_PROXY_USERNAME, configuration);
            this.proxyPassword = ConfigurationHelper.getStringProperty("socksPassword", TransportConstants.DEFAULT_PROXY_PASSWORD, configuration);
            this.proxyRemoteDNS = ConfigurationHelper.getBooleanProperty("socksRemoteDNS", false, configuration);
        }
        this.remotingThreads = ConfigurationHelper.getIntProperty("nioRemotingThreads", -1, configuration);
        this.remotingThreads = ConfigurationHelper.getIntProperty("remotingThreads", this.remotingThreads, configuration);
        this.useGlobalWorkerPool = ConfigurationHelper.getBooleanProperty("useNioGlobalWorkerPool", true, configuration);
        this.useGlobalWorkerPool = ConfigurationHelper.getBooleanProperty("useGlobalWorkerPool", this.useGlobalWorkerPool, configuration);
        this.useEpoll = ConfigurationHelper.getBooleanProperty("useEpoll", true, configuration);
        this.useKQueue = ConfigurationHelper.getBooleanProperty("useKQueue", true, configuration);
        this.useServlet = ConfigurationHelper.getBooleanProperty("useServlet", false, configuration);
        this.host = ConfigurationHelper.getStringProperty("host", "localhost", configuration);
        this.port = ConfigurationHelper.getIntProperty("port", 61616, configuration);
        this.localAddress = ConfigurationHelper.getStringProperty("localAddress", TransportConstants.DEFAULT_LOCAL_ADDRESS, configuration);
        this.localPort = ConfigurationHelper.getIntProperty("localPort", 0, configuration);
        if (this.sslEnabled) {
            this.keyStoreProvider = ConfigurationHelper.getStringProperty("keyStoreProvider", TransportConstants.DEFAULT_KEYSTORE_PROVIDER, configuration);
            this.keyStoreType = ConfigurationHelper.getStringProperty("keyStoreType", "JKS", configuration);
            this.keyStorePath = ConfigurationHelper.getStringProperty("keyStorePath", TransportConstants.DEFAULT_KEYSTORE_PATH, configuration);
            this.keyStorePassword = ConfigurationHelper.getPasswordProperty("keyStorePassword", TransportConstants.DEFAULT_KEYSTORE_PASSWORD, configuration, ActiveMQDefaultConfiguration.getPropMaskPassword(), ActiveMQDefaultConfiguration.getPropPasswordCodec());
            this.trustStoreProvider = ConfigurationHelper.getStringProperty("trustStoreProvider", TransportConstants.DEFAULT_TRUSTSTORE_PROVIDER, configuration);
            this.trustStoreType = ConfigurationHelper.getStringProperty("trustStoreType", "JKS", configuration);
            this.trustStorePath = ConfigurationHelper.getStringProperty("trustStorePath", TransportConstants.DEFAULT_TRUSTSTORE_PATH, configuration);
            this.trustStorePassword = ConfigurationHelper.getPasswordProperty("trustStorePassword", TransportConstants.DEFAULT_TRUSTSTORE_PASSWORD, configuration, ActiveMQDefaultConfiguration.getPropMaskPassword(), ActiveMQDefaultConfiguration.getPropPasswordCodec());
            this.crlPath = ConfigurationHelper.getStringProperty("crlPath", TransportConstants.DEFAULT_CRL_PATH, configuration);
            this.enabledCipherSuites = ConfigurationHelper.getStringProperty("enabledCipherSuites", TransportConstants.DEFAULT_ENABLED_CIPHER_SUITES, configuration);
            this.enabledProtocols = ConfigurationHelper.getStringProperty("enabledProtocols", TransportConstants.DEFAULT_ENABLED_PROTOCOLS, configuration);
            this.verifyHost = ConfigurationHelper.getBooleanProperty("verifyHost", true, configuration);
            this.trustAll = ConfigurationHelper.getBooleanProperty("trustAll", false, configuration);
            this.forceSSLParameters = ConfigurationHelper.getBooleanProperty("forceSSLParameters", false, configuration);
            this.sslProvider = ConfigurationHelper.getStringProperty("sslProvider", "JDK", configuration);
            this.sniHost = ConfigurationHelper.getStringProperty("sniHost", TransportConstants.DEFAULT_SNIHOST_CONFIG, configuration);
            this.useDefaultSslContext = ConfigurationHelper.getBooleanProperty("useDefaultSslContext", false, configuration);
            this.trustManagerFactoryPlugin = ConfigurationHelper.getStringProperty("trustManagerFactoryPlugin", TransportConstants.DEFAULT_TRUST_MANAGER_FACTORY_PLUGIN, configuration);
        } else {
            this.keyStoreProvider = TransportConstants.DEFAULT_KEYSTORE_PROVIDER;
            this.keyStoreType = "JKS";
            this.keyStorePath = TransportConstants.DEFAULT_KEYSTORE_PATH;
            this.keyStorePassword = TransportConstants.DEFAULT_KEYSTORE_PASSWORD;
            this.trustStoreProvider = TransportConstants.DEFAULT_TRUSTSTORE_PROVIDER;
            this.trustStoreType = "JKS";
            this.trustStorePath = TransportConstants.DEFAULT_TRUSTSTORE_PATH;
            this.trustStorePassword = TransportConstants.DEFAULT_TRUSTSTORE_PASSWORD;
            this.crlPath = TransportConstants.DEFAULT_CRL_PATH;
            this.enabledCipherSuites = TransportConstants.DEFAULT_ENABLED_CIPHER_SUITES;
            this.enabledProtocols = TransportConstants.DEFAULT_ENABLED_PROTOCOLS;
            this.verifyHost = true;
            this.trustAll = false;
            this.sniHost = TransportConstants.DEFAULT_SNIHOST_CONFIG;
            this.useDefaultSslContext = false;
            this.trustManagerFactoryPlugin = TransportConstants.DEFAULT_TRUST_MANAGER_FACTORY_PLUGIN;
        }
        this.tcpNoDelay = ConfigurationHelper.getBooleanProperty("tcpNoDelay", true, configuration);
        this.tcpSendBufferSize = ConfigurationHelper.getIntProperty("tcpSendBufferSize", 0x100000, configuration);
        this.tcpReceiveBufferSize = ConfigurationHelper.getIntProperty("tcpReceiveBufferSize", 0x100000, configuration);
        this.writeBufferLowWaterMark = ConfigurationHelper.getIntProperty("writeBufferLowWaterMark", 32768, configuration);
        this.writeBufferHighWaterMark = ConfigurationHelper.getIntProperty("writeBufferHighWaterMark", 131072, configuration);
        this.batchDelay = ConfigurationHelper.getLongProperty("batchDelay", 0L, configuration);
        this.connectTimeoutMillis = ConfigurationHelper.getIntProperty("connect-timeout-millis", -1, configuration);
        this.closeExecutor = closeExecutor;
        this.scheduledThreadPool = scheduledThreadPool;
    }

    public String toString() {
        return "NettyConnector [host=" + this.host + ", port=" + this.port + ", httpEnabled=" + this.httpEnabled + ", httpUpgradeEnabled=" + this.httpUpgradeEnabled + ", useServlet=" + this.useServlet + ", servletPath=" + this.servletPath + ", sslEnabled=" + this.sslEnabled + ", useNio=" + true + this.getHttpUpgradeInfo() + "]";
    }

    public ChannelGroup getChannelGroup() {
        return this.channelGroup;
    }

    public boolean isServerConnection() {
        return this.serverConnection;
    }

    private String getHttpUpgradeInfo() {
        if (!this.httpUpgradeEnabled) {
            return "";
        }
        String serverName = ConfigurationHelper.getStringProperty("activemqServerName", null, this.configuration);
        String acceptor = ConfigurationHelper.getStringProperty("httpUpgradeEndpoint", null, this.configuration);
        return ", activemqServerName=" + serverName + ", httpUpgradeEndpoint=" + acceptor;
    }

    @Override
    public synchronized void start() {
        String realTrustStorePassword;
        String realTrustStoreType;
        String realTrustStoreProvider;
        String realTrustStorePath;
        String realKeyStorePassword;
        String realKeyStoreType;
        String realKeyStoreProvider;
        String realKeyStorePath;
        String connectorType;
        if (this.channelClazz != null) {
            return;
        }
        if (this.remotingThreads == -1) {
            this.remotingThreads = Runtime.getRuntime().availableProcessors() * 3;
        }
        if (this.useEpoll && CheckDependencies.isEpollAvailable()) {
            this.group = this.useGlobalWorkerPool ? SharedEventLoopGroup.getInstance(threadFactory -> new EpollEventLoopGroup(this.remotingThreads, (ThreadFactory)threadFactory)) : new EpollEventLoopGroup(this.remotingThreads);
            connectorType = EPOLL_CONNECTOR_TYPE;
            this.channelClazz = EpollSocketChannel.class;
            logger.debug("Connector " + this + " using native epoll");
        } else if (this.useKQueue && CheckDependencies.isKQueueAvailable()) {
            this.group = this.useGlobalWorkerPool ? SharedEventLoopGroup.getInstance(threadFactory -> new KQueueEventLoopGroup(this.remotingThreads, (ThreadFactory)threadFactory)) : new KQueueEventLoopGroup(this.remotingThreads);
            connectorType = KQUEUE_CONNECTOR_TYPE;
            this.channelClazz = KQueueSocketChannel.class;
            logger.debug("Connector " + this + " using native kqueue");
        } else {
            if (this.useGlobalWorkerPool) {
                this.channelClazz = NioSocketChannel.class;
                this.group = SharedEventLoopGroup.getInstance(threadFactory -> new NioEventLoopGroup(this.remotingThreads, (ThreadFactory)threadFactory));
            } else {
                this.channelClazz = NioSocketChannel.class;
                this.group = new NioEventLoopGroup(this.remotingThreads);
            }
            connectorType = NIO_CONNECTOR_TYPE;
            this.channelClazz = NioSocketChannel.class;
            logger.debug("Connector + " + this + " using nio");
        }
        this.bootstrap = new Bootstrap();
        this.bootstrap.channel(this.channelClazz);
        this.bootstrap.group(this.group);
        this.bootstrap.option(ChannelOption.TCP_NODELAY, this.tcpNoDelay);
        if (this.connectTimeoutMillis != -1) {
            this.bootstrap.option(ChannelOption.CONNECT_TIMEOUT_MILLIS, this.connectTimeoutMillis);
        }
        if (this.tcpReceiveBufferSize != -1) {
            this.bootstrap.option(ChannelOption.SO_RCVBUF, this.tcpReceiveBufferSize);
        }
        if (this.tcpSendBufferSize != -1) {
            this.bootstrap.option(ChannelOption.SO_SNDBUF, this.tcpSendBufferSize);
        }
        int writeBufferLowWaterMark = this.writeBufferLowWaterMark != -1 ? this.writeBufferLowWaterMark : WriteBufferWaterMark.DEFAULT.low();
        int writeBufferHighWaterMark = this.writeBufferHighWaterMark != -1 ? this.writeBufferHighWaterMark : WriteBufferWaterMark.DEFAULT.high();
        WriteBufferWaterMark writeBufferWaterMark = new WriteBufferWaterMark(writeBufferLowWaterMark, writeBufferHighWaterMark);
        this.bootstrap.option(ChannelOption.WRITE_BUFFER_WATER_MARK, writeBufferWaterMark);
        this.bootstrap.option(ChannelOption.SO_KEEPALIVE, true);
        this.bootstrap.option(ChannelOption.SO_REUSEADDR, true);
        this.channelGroup = new DefaultChannelGroup("activemq-connector", GlobalEventExecutor.INSTANCE);
        if (this.sslEnabled) {
            if (this.forceSSLParameters) {
                realKeyStorePath = this.keyStorePath;
                realKeyStoreProvider = this.keyStoreProvider;
                realKeyStoreType = this.keyStoreType;
                realKeyStorePassword = this.keyStorePassword;
                realTrustStorePath = this.trustStorePath;
                realTrustStoreProvider = this.trustStoreProvider;
                realTrustStoreType = this.trustStoreType;
                realTrustStorePassword = this.trustStorePassword;
            } else {
                realKeyStorePath = Stream.of(System.getProperty(ACTIVEMQ_KEYSTORE_PATH_PROP_NAME), System.getProperty(JAVAX_KEYSTORE_PATH_PROP_NAME), this.keyStorePath).map(v -> this.useDefaultSslContext ? this.keyStorePath : v).filter(Objects::nonNull).findFirst().orElse(null);
                realKeyStorePassword = Stream.of(System.getProperty(ACTIVEMQ_KEYSTORE_PASSWORD_PROP_NAME), System.getProperty(JAVAX_KEYSTORE_PASSWORD_PROP_NAME), this.keyStorePassword).map(v -> this.useDefaultSslContext ? this.keyStorePassword : v).filter(Objects::nonNull).findFirst().orElse(null);
                Pair<String, String> keyStoreCompat = SSLSupport.getValidProviderAndType(Stream.of(System.getProperty(ACTIVEMQ_KEYSTORE_PROVIDER_PROP_NAME), System.getProperty(JAVAX_KEYSTORE_PROVIDER_PROP_NAME), this.keyStoreProvider).map(v -> this.useDefaultSslContext ? this.keyStoreProvider : v).filter(Objects::nonNull).findFirst().orElse(null), Stream.of(System.getProperty(ACTIVEMQ_KEYSTORE_TYPE_PROP_NAME), System.getProperty(JAVAX_KEYSTORE_TYPE_PROP_NAME), this.keyStoreType).map(v -> this.useDefaultSslContext ? this.keyStoreType : v).filter(Objects::nonNull).findFirst().orElse(null));
                realKeyStoreProvider = keyStoreCompat.getA();
                realKeyStoreType = keyStoreCompat.getB();
                realTrustStorePath = Stream.of(System.getProperty(ACTIVEMQ_TRUSTSTORE_PATH_PROP_NAME), System.getProperty(JAVAX_TRUSTSTORE_PATH_PROP_NAME), this.trustStorePath).map(v -> this.useDefaultSslContext ? this.trustStorePath : v).filter(Objects::nonNull).findFirst().orElse(null);
                realTrustStorePassword = Stream.of(System.getProperty(ACTIVEMQ_TRUSTSTORE_PASSWORD_PROP_NAME), System.getProperty(JAVAX_TRUSTSTORE_PASSWORD_PROP_NAME), this.trustStorePassword).map(v -> this.useDefaultSslContext ? this.trustStorePassword : v).filter(Objects::nonNull).findFirst().orElse(null);
                Pair<String, String> trustStoreCompat = SSLSupport.getValidProviderAndType(Stream.of(System.getProperty(ACTIVEMQ_TRUSTSTORE_PROVIDER_PROP_NAME), System.getProperty(JAVAX_TRUSTSTORE_PROVIDER_PROP_NAME), this.trustStoreProvider).map(v -> this.useDefaultSslContext ? this.trustStoreProvider : v).filter(Objects::nonNull).findFirst().orElse(null), Stream.of(System.getProperty(ACTIVEMQ_TRUSTSTORE_TYPE_PROP_NAME), System.getProperty(JAVAX_TRUSTSTORE_TYPE_PROP_NAME), this.trustStoreType).map(v -> this.useDefaultSslContext ? this.trustStoreType : v).filter(Objects::nonNull).findFirst().orElse(null));
                realTrustStoreProvider = trustStoreCompat.getA();
                realTrustStoreType = trustStoreCompat.getB();
            }
        } else {
            realKeyStorePath = null;
            realKeyStoreProvider = null;
            realKeyStoreType = null;
            realKeyStorePassword = null;
            realTrustStorePath = null;
            realTrustStoreProvider = null;
            realTrustStoreType = null;
            realTrustStorePassword = null;
        }
        this.bootstrap.handler(new ChannelInitializer<Channel>(){

            @Override
            public void initChannel(Channel channel) throws Exception {
                ChannelPipeline pipeline = channel.pipeline();
                if (NettyConnector.this.proxyEnabled && (NettyConnector.this.proxyRemoteDNS || !NettyConnector.this.isTargetLocalHost())) {
                    ProxyHandler proxyHandler;
                    InetSocketAddress proxyAddress = new InetSocketAddress(NettyConnector.this.proxyHost, NettyConnector.this.proxyPort);
                    switch (NettyConnector.this.proxyVersion) {
                        case SOCKS5: {
                            proxyHandler = new Socks5ProxyHandler(proxyAddress, NettyConnector.this.proxyUsername, NettyConnector.this.proxyPassword);
                            break;
                        }
                        case SOCKS4a: {
                            proxyHandler = new Socks4ProxyHandler(proxyAddress, NettyConnector.this.proxyUsername);
                            break;
                        }
                        default: {
                            throw new IllegalArgumentException("Unknown SOCKS proxy version");
                        }
                    }
                    channel.pipeline().addLast(proxyHandler);
                    logger.debug("Using a SOCKS proxy at " + NettyConnector.this.proxyHost + ":" + NettyConnector.this.proxyPort);
                    if (NettyConnector.this.proxyRemoteDNS) {
                        NettyConnector.this.bootstrap.resolver(NoopAddressResolverGroup.INSTANCE);
                    }
                }
                if (NettyConnector.this.sslEnabled && !NettyConnector.this.useServlet) {
                    SSLParameters sslParameters;
                    SSLContextConfig sslContextConfig = SSLContextConfig.builder().keystoreProvider(realKeyStoreProvider).keystorePath(realKeyStorePath).keystoreType(realKeyStoreType).keystorePassword(realKeyStorePassword).truststoreProvider(realTrustStoreProvider).truststorePath(realTrustStorePath).truststoreType(realTrustStoreType).truststorePassword(realTrustStorePassword).trustManagerFactoryPlugin(NettyConnector.this.trustManagerFactoryPlugin).crlPath(NettyConnector.this.crlPath).trustAll(NettyConnector.this.trustAll).build();
                    SSLEngine engine = NettyConnector.this.sslProvider.equals("OPENSSL") ? NettyConnector.this.loadOpenSslEngine(channel.alloc(), sslContextConfig) : NettyConnector.this.loadJdkSslEngine(sslContextConfig);
                    engine.setUseClientMode(true);
                    engine.setWantClientAuth(true);
                    String[] originalProtocols = engine.getEnabledProtocols();
                    if (NettyConnector.this.enabledCipherSuites != null) {
                        try {
                            engine.setEnabledCipherSuites(SSLSupport.parseCommaSeparatedListIntoArray(NettyConnector.this.enabledCipherSuites));
                        }
                        catch (IllegalArgumentException e) {
                            ActiveMQClientLogger.LOGGER.invalidCipherSuite(SSLSupport.parseArrayIntoCommandSeparatedList(engine.getSupportedCipherSuites()));
                            throw e;
                        }
                    }
                    if (NettyConnector.this.enabledProtocols != null) {
                        try {
                            engine.setEnabledProtocols(SSLSupport.parseCommaSeparatedListIntoArray(NettyConnector.this.enabledProtocols));
                        }
                        catch (IllegalArgumentException e) {
                            ActiveMQClientLogger.LOGGER.invalidProtocol(SSLSupport.parseArrayIntoCommandSeparatedList(engine.getSupportedProtocols()));
                            throw e;
                        }
                    } else {
                        engine.setEnabledProtocols(originalProtocols);
                    }
                    if (NettyConnector.this.verifyHost) {
                        sslParameters = engine.getSSLParameters();
                        sslParameters.setEndpointIdentificationAlgorithm("HTTPS");
                        engine.setSSLParameters(sslParameters);
                    }
                    if (NettyConnector.this.sniHost != null) {
                        sslParameters = engine.getSSLParameters();
                        sslParameters.setServerNames(Arrays.asList(new SNIHostName(NettyConnector.this.sniHost)));
                        engine.setSSLParameters(sslParameters);
                    }
                    SslHandler handler = new SslHandler(engine);
                    pipeline.addLast("ssl", (ChannelHandler)handler);
                }
                if (NettyConnector.this.httpEnabled) {
                    pipeline.addLast(new HttpRequestEncoder());
                    pipeline.addLast(new HttpResponseDecoder());
                    pipeline.addLast(new HttpObjectAggregator(Integer.MAX_VALUE));
                    pipeline.addLast(new HttpHandler());
                }
                if (NettyConnector.this.httpUpgradeEnabled) {
                    HttpClientCodec httpClientCodec = new HttpClientCodec();
                    pipeline.addLast(httpClientCodec);
                    pipeline.addLast("http-upgrade", (ChannelHandler)new HttpUpgradeHandler(pipeline, httpClientCodec));
                }
                if (NettyConnector.this.protocolManager != null) {
                    NettyConnector.this.protocolManager.addChannelHandlers(pipeline);
                }
                if (NettyConnector.this.handler != null) {
                    pipeline.addLast(new ActiveMQClientChannelHandler(NettyConnector.this.channelGroup, NettyConnector.this.handler, new Listener(), NettyConnector.this.closeExecutor));
                    logger.debugf("Added ActiveMQClientChannelHandler to Channel with id = %s ", (Object)channel.id());
                }
            }
        });
        if (this.batchDelay > 0L) {
            this.flusher = new BatchFlusher();
            this.batchFlusherFuture = this.scheduledThreadPool.scheduleWithFixedDelay(this.flusher, this.batchDelay, this.batchDelay, TimeUnit.MILLISECONDS);
        }
        ActiveMQClientLogger.LOGGER.startedNettyConnector(connectorType, TransportConstants.NETTY_VERSION, this.host, this.port);
    }

    private SSLEngine loadJdkSslEngine(SSLContextConfig sslContextConfig) throws Exception {
        SSLContext context = SSLContextFactoryProvider.getSSLContextFactory().getSSLContext(sslContextConfig, this.configuration);
        if (this.host != null && this.port != -1) {
            return context.createSSLEngine(this.host, this.port);
        }
        return context.createSSLEngine();
    }

    private SSLEngine loadOpenSslEngine(ByteBufAllocator alloc, SSLContextConfig sslContextConfig) throws Exception {
        SslContext context = OpenSSLContextFactoryProvider.getOpenSSLContextFactory().getClientSslContext(sslContextConfig, this.configuration);
        if (this.host != null && this.port != -1) {
            return context.newEngine(alloc, this.host, this.port);
        }
        return context.newEngine(alloc);
    }

    @Override
    public synchronized void close() {
        if (this.channelClazz == null) {
            return;
        }
        if (this.batchFlusherFuture != null) {
            this.batchFlusherFuture.cancel(false);
            this.flusher.cancel();
            this.flusher = null;
            this.batchFlusherFuture = null;
        }
        this.bootstrap = null;
        this.channelGroup.close().awaitUninterruptibly();
        this.group.shutdownGracefully(100L, 3000L, TimeUnit.MILLISECONDS);
        this.channelClazz = null;
        for (Connection connection : this.connections.values()) {
            this.listener.connectionDestroyed(connection.getID());
        }
        this.connections.clear();
    }

    @Override
    public boolean isStarted() {
        return this.channelClazz != null;
    }

    @Override
    public Connection createConnection() {
        return this.createConnection(null);
    }

    public final Connection createConnection(Consumer<ChannelFuture> onConnect) {
        if (this.channelClazz == null) {
            return null;
        }
        return this.createConnection(onConnect, this.host, this.port);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public NettyConnection createConnection(Consumer<ChannelFuture> onConnect, String host, int port) {
        ChannelFuture future;
        InetSocketAddress remoteDestination = this.proxyEnabled && this.proxyRemoteDNS ? InetSocketAddress.createUnresolved(IPV6Util.stripBracketsAndZoneID(host), port) : new InetSocketAddress(IPV6Util.stripBracketsAndZoneID(host), port);
        logger.debug("Remote destination: " + remoteDestination);
        if (this.localPort != 0) {
            InetSocketAddress localDestination = this.localAddress != null ? new InetSocketAddress(this.localAddress, this.localPort) : new InetSocketAddress(this.localPort);
            future = this.bootstrap.connect(remoteDestination, localDestination);
        } else {
            future = this.bootstrap.connect(remoteDestination);
        }
        if (onConnect != null) {
            onConnect.accept(future);
        }
        future.awaitUninterruptibly();
        if (future.isSuccess()) {
            Channel ch;
            block20: {
                ch = future.channel();
                SslHandler sslHandler = ch.pipeline().get(SslHandler.class);
                if (sslHandler != null) {
                    io.netty.util.concurrent.Future<Channel> handshakeFuture = sslHandler.handshakeFuture();
                    if (!handshakeFuture.awaitUninterruptibly(30000L)) {
                        ch.close().awaitUninterruptibly();
                        return null;
                    }
                    if (!handshakeFuture.isSuccess()) {
                        ch.close().awaitUninterruptibly();
                        ActiveMQClientLogger.LOGGER.errorCreatingNettyConnection(handshakeFuture.cause());
                        return null;
                    }
                    ChannelPipeline channelPipeline = ch.pipeline();
                    ActiveMQChannelHandler channelHandler = channelPipeline.get(ActiveMQChannelHandler.class);
                    if (!this.serverConnection) {
                        if (channelHandler == null) {
                            ch.close().awaitUninterruptibly();
                            ActiveMQClientLogger.LOGGER.errorCreatingNettyConnection(new IllegalStateException("No ActiveMQChannelHandler has been found while connecting to " + remoteDestination + " from Channel with id = " + ch.id()));
                            return null;
                        }
                        channelHandler.active = true;
                    }
                }
                if (this.httpUpgradeEnabled) {
                    try {
                        String endpoint;
                        HttpUpgradeHandler httpUpgradeHandler = (HttpUpgradeHandler)ch.pipeline().get("http-upgrade");
                        String scheme = "http";
                        if (this.sslEnabled) {
                            scheme = "https";
                        }
                        String ipv6Host = IPV6Util.encloseHost(host);
                        URI uri = new URI(scheme, null, ipv6Host, port, null, null, null);
                        DefaultHttpRequest request = new DefaultHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.GET, uri.getRawPath());
                        request.headers().set((CharSequence)HttpHeaderNames.HOST, (Object)ipv6Host);
                        request.headers().set((CharSequence)HttpHeaderNames.UPGRADE, (Object)ACTIVEMQ_REMOTING);
                        request.headers().set((CharSequence)HttpHeaderNames.CONNECTION, (Object)HttpHeaderNames.UPGRADE);
                        String serverName = ConfigurationHelper.getStringProperty("activemqServerName", null, this.configuration);
                        if (serverName != null) {
                            request.headers().set("activemqServerName", (Object)serverName);
                        }
                        if ((endpoint = ConfigurationHelper.getStringProperty("httpUpgradeEndpoint", null, this.configuration)) != null) {
                            request.headers().set("httpUpgradeEndpoint", (Object)endpoint);
                        }
                        byte[] nonce = NettyConnector.randomBytes(16);
                        String key = NettyConnector.base64(nonce);
                        request.headers().set(SEC_ACTIVEMQ_REMOTING_KEY, (Object)key);
                        ch.attr(REMOTING_KEY).set(key);
                        logger.debugf("Sending HTTP request %s", (Object)request);
                        ch.writeAndFlush(request);
                        if (!httpUpgradeHandler.awaitHandshake()) {
                            ch.close().awaitUninterruptibly();
                            return null;
                        }
                        break block20;
                    }
                    catch (URISyntaxException e) {
                        ActiveMQClientLogger.LOGGER.errorCreatingNettyConnection(e);
                        return null;
                    }
                }
                ChannelPipeline channelPipeline = ch.pipeline();
                ActiveMQChannelHandler channelHandler = channelPipeline.get(ActiveMQChannelHandler.class);
                if (channelHandler != null) {
                    channelHandler.active = true;
                } else if (!this.serverConnection) {
                    ch.close().awaitUninterruptibly();
                    ActiveMQClientLogger.LOGGER.errorCreatingNettyConnection(new IllegalStateException("No ActiveMQChannelHandler has been found while connecting to " + remoteDestination + " from Channel with id = " + ch.id()));
                    return null;
                }
            }
            Listener connectionListener = new Listener();
            NettyConnection conn = new NettyConnection(this.configuration, ch, connectionListener, !this.httpEnabled && this.batchDelay > 0L, false);
            connectionListener.connectionCreated((ActiveMQComponent)null, (Connection)conn, this.protocolManager);
            return conn;
        }
        Throwable t = future.cause();
        if (t != null && !(t instanceof ConnectException)) {
            ActiveMQClientLogger.LOGGER.errorCreatingNettyConnection(future.cause());
        }
        return null;
    }

    public int getConnectTimeoutMillis() {
        return this.connectTimeoutMillis;
    }

    public void setConnectTimeoutMillis(int connectTimeoutMillis) {
        this.connectTimeoutMillis = connectTimeoutMillis;
    }

    @Override
    public boolean isEquivalent(Map<String, Object> configuration) {
        boolean httpUpgradeEnabled = ConfigurationHelper.getBooleanProperty("httpUpgradeEnabled", false, configuration);
        if (httpUpgradeEnabled) {
            String otherActiveMQServerName = ConfigurationHelper.getStringProperty("activemqServerName", null, configuration);
            String activeMQServerName = ConfigurationHelper.getStringProperty("activemqServerName", null, this.configuration);
            boolean equivalent = this.isSameHostAndPort(configuration) && otherActiveMQServerName != null && otherActiveMQServerName.equals(activeMQServerName);
            return equivalent;
        }
        return this.isSameHostAndPort(configuration);
    }

    private boolean isSameHostAndPort(Map<String, Object> configuration) {
        String host = ConfigurationHelper.getStringProperty("host", "localhost", configuration);
        int port = ConfigurationHelper.getIntProperty("port", 61616, configuration);
        if (port != this.port) {
            return false;
        }
        if (host.equals(this.host)) {
            return true;
        }
        boolean result = false;
        try {
            InetAddress inetAddr1 = InetAddress.getByName(host);
            InetAddress inetAddr2 = InetAddress.getByName(this.host);
            String ip1 = inetAddr1.getHostAddress();
            String ip2 = inetAddr2.getHostAddress();
            logger.debug(this + " host 1: " + host + " ip address: " + ip1 + " host 2: " + this.host + " ip address: " + ip2);
            result = ip1.equals(ip2);
        }
        catch (UnknownHostException e) {
            ActiveMQClientLogger.LOGGER.unableToResolveHost(e);
        }
        return result;
    }

    private boolean isTargetLocalHost() {
        try {
            InetAddress address = InetAddress.getByName(this.host);
            return address.isLoopbackAddress();
        }
        catch (UnknownHostException e) {
            ActiveMQClientLogger.LOGGER.error("Cannot resolve host", e);
            return false;
        }
    }

    public void finalize() throws Throwable {
        this.close();
        super.finalize();
    }

    public Bootstrap getBootStrap() {
        return this.bootstrap;
    }

    public static void clearThreadPools() {
        SharedEventLoopGroup.forceShutdown();
    }

    private static String base64(byte[] data) {
        ByteBuf encodedData = Unpooled.wrappedBuffer(data);
        ByteBuf encoded = Base64.encode(encodedData);
        String encodedString = encoded.toString(StandardCharsets.UTF_8);
        encoded.release();
        return encodedString;
    }

    private static byte[] randomBytes(int size) {
        byte[] bytes = new byte[size];
        for (int index = 0; index < size; ++index) {
            bytes[index] = (byte)NettyConnector.randomNumber(0, 255);
        }
        return bytes;
    }

    private static int randomNumber(int minimum, int maximum) {
        return (int)(Math.random() * (double)maximum + (double)minimum);
    }

    public static String createExpectedResponse(String magicNumber, String secretKey) throws IOException {
        try {
            String concat = secretKey + magicNumber;
            MessageDigest digest = MessageDigest.getInstance("SHA1");
            digest.update(concat.getBytes(StandardCharsets.UTF_8));
            byte[] bytes = digest.digest();
            return org.apache.activemq.artemis.utils.Base64.encodeBytes(bytes);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IOException(e);
        }
    }

    static {
        ResourceLeakDetector.setLevel(ResourceLeakDetector.Level.DISABLED);
        HashMap<String, Object> config = new HashMap<String, Object>();
        config.put("host", "localhost");
        config.put("port", 61616);
        DEFAULT_CONFIG = Collections.unmodifiableMap(config);
    }

    private class BatchFlusher
    implements Runnable {
        private boolean cancelled;

        private BatchFlusher() {
        }

        @Override
        public synchronized void run() {
            if (!this.cancelled) {
                for (Connection connection : NettyConnector.this.connections.values()) {
                    connection.checkFlushBatchBuffer();
                }
            }
        }

        public synchronized void cancel() {
            this.cancelled = true;
        }
    }

    private class Listener
    implements ClientConnectionLifeCycleListener {
        private Listener() {
        }

        @Override
        public void connectionCreated(ActiveMQComponent component, Connection connection, ClientProtocolManager protocol) {
            if (NettyConnector.this.connections.putIfAbsent(connection.getID(), connection) != null) {
                throw ActiveMQClientMessageBundle.BUNDLE.connectionExists(connection.getID());
            }
            BaseConnectionLifeCycleListener clientListener = NettyConnector.this.listener;
            clientListener.connectionCreated(component, connection, protocol);
        }

        @Override
        public void connectionDestroyed(final Object connectionID) {
            if (NettyConnector.this.connections.remove(connectionID) != null) {
                NettyConnector.this.closeExecutor.execute(new Runnable(){

                    @Override
                    public void run() {
                        NettyConnector.this.listener.connectionDestroyed(connectionID);
                    }
                });
            }
        }

        @Override
        public void connectionException(final Object connectionID, final ActiveMQException me) {
            NettyConnector.this.closeExecutor.execute(new Runnable(){

                @Override
                public void run() {
                    NettyConnector.this.listener.connectionException(connectionID, me);
                }
            });
        }

        @Override
        public void connectionReadyForWrites(Object connectionID, boolean ready) {
            NettyConnection connection = (NettyConnection)NettyConnector.this.connections.get(connectionID);
            if (connection != null) {
                connection.fireReady(ready);
            }
            NettyConnector.this.listener.connectionReadyForWrites(connectionID, ready);
        }
    }

    class HttpHandler
    extends ChannelDuplexHandler {
        private Channel channel;
        private long lastSendTime = 0L;
        private boolean waitingGet = false;
        private HttpIdleTimer task;
        private final String url;
        private final FutureLatch handShakeFuture = new FutureLatch();
        private boolean active = false;
        private boolean handshaking = false;
        private String cookie;

        HttpHandler() throws Exception {
            this.url = new URI("http", null, NettyConnector.this.host, NettyConnector.this.port, NettyConnector.this.servletPath, null, null).toString();
        }

        @Override
        public void channelActive(ChannelHandlerContext ctx) throws Exception {
            super.channelActive(ctx);
            this.channel = ctx.channel();
            if (NettyConnector.this.httpClientIdleScanPeriod > 0L) {
                this.task = new HttpIdleTimer();
                ScheduledFuture<?> future = NettyConnector.this.scheduledThreadPool.scheduleAtFixedRate(this.task, NettyConnector.this.httpClientIdleScanPeriod, NettyConnector.this.httpClientIdleScanPeriod, TimeUnit.MILLISECONDS);
                this.task.setFuture(future);
            }
        }

        @Override
        public void channelInactive(ChannelHandlerContext ctx) throws Exception {
            if (this.task != null) {
                this.task.close();
            }
            super.channelInactive(ctx);
        }

        @Override
        public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
            FullHttpResponse response = (FullHttpResponse)msg;
            if (NettyConnector.this.httpRequiresSessionId && !this.active) {
                List<String> setCookieHeaderValues = response.headers().getAll(HttpHeaderNames.SET_COOKIE);
                for (String setCookieHeaderValue : setCookieHeaderValues) {
                    Cookie cookie = ClientCookieDecoder.LAX.decode(setCookieHeaderValue);
                    if (!"JSESSIONID".equals(cookie.name())) continue;
                    this.cookie = setCookieHeaderValue;
                    break;
                }
                this.active = true;
                this.handShakeFuture.run();
            }
            this.waitingGet = false;
            ctx.fireChannelRead(response.content());
        }

        @Override
        public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
            if (msg instanceof ByteBuf) {
                if (NettyConnector.this.httpRequiresSessionId && !this.active) {
                    if (this.handshaking) {
                        this.handshaking = true;
                    } else if (!this.handShakeFuture.await(5000L)) {
                        throw new RuntimeException("Handshake failed after timeout");
                    }
                }
                ByteBuf buf = (ByteBuf)msg;
                DefaultFullHttpRequest httpRequest = new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.POST, this.url, buf);
                httpRequest.headers().add((CharSequence)HttpHeaderNames.HOST, (Object)NettyConnector.this.host);
                if (this.cookie != null) {
                    httpRequest.headers().add((CharSequence)HttpHeaderNames.COOKIE, (Object)this.cookie);
                }
                httpRequest.headers().add((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)String.valueOf(buf.readableBytes()));
                ctx.write(httpRequest, promise);
                this.lastSendTime = System.currentTimeMillis();
            } else {
                ctx.write(msg, promise);
                this.lastSendTime = System.currentTimeMillis();
            }
        }

        private class HttpIdleTimer
        implements Runnable {
            private boolean closed = false;
            private Future<?> future;

            private HttpIdleTimer() {
            }

            @Override
            public synchronized void run() {
                if (this.closed) {
                    return;
                }
                if (!HttpHandler.this.waitingGet && System.currentTimeMillis() > HttpHandler.this.lastSendTime + NettyConnector.this.httpMaxClientIdleTime) {
                    DefaultFullHttpRequest httpRequest = new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.GET, HttpHandler.this.url);
                    httpRequest.headers().add((CharSequence)HttpHeaderNames.HOST, (Object)NettyConnector.this.host);
                    HttpHandler.this.waitingGet = true;
                    HttpHandler.this.channel.writeAndFlush(httpRequest);
                }
            }

            public synchronized void setFuture(Future<?> future) {
                this.future = future;
            }

            public void close() {
                if (this.future != null) {
                    this.future.cancel(false);
                }
                this.closed = true;
            }
        }
    }

    private static class HttpUpgradeHandler
    extends SimpleChannelInboundHandler<HttpObject> {
        private final ChannelPipeline pipeline;
        private final HttpClientCodec httpClientCodec;
        private final CountDownLatch latch = new CountDownLatch(1);
        private boolean handshakeComplete = false;

        private HttpUpgradeHandler(ChannelPipeline pipeline, HttpClientCodec httpClientCodec) {
            this.pipeline = pipeline;
            this.httpClientCodec = httpClientCodec;
        }

        @Override
        public void channelRead0(ChannelHandlerContext ctx, HttpObject msg) throws Exception {
            if (logger.isDebugEnabled()) {
                logger.debug("Received msg=" + msg);
            }
            if (msg instanceof HttpResponse) {
                HttpResponse response = (HttpResponse)msg;
                if (response.status().code() == HttpResponseStatus.SWITCHING_PROTOCOLS.code() && response.headers().get(HttpHeaderNames.UPGRADE).equals(NettyConnector.ACTIVEMQ_REMOTING)) {
                    String accept = response.headers().get(NettyConnector.SEC_ACTIVEMQ_REMOTING_ACCEPT);
                    String expectedResponse = NettyConnector.createExpectedResponse(NettyConnector.MAGIC_NUMBER, (String)ctx.channel().attr(REMOTING_KEY).get());
                    if (expectedResponse.equals(accept)) {
                        this.handshakeComplete = true;
                    } else {
                        ActiveMQClientLogger.LOGGER.httpHandshakeFailed(msg);
                        ctx.close();
                        this.latch.countDown();
                    }
                    return;
                }
            } else if (msg == LastHttpContent.EMPTY_LAST_CONTENT && this.handshakeComplete) {
                this.pipeline.remove(this.httpClientCodec);
                this.pipeline.remove(this);
                ActiveMQChannelHandler channelHandler = this.pipeline.get(ActiveMQChannelHandler.class);
                channelHandler.active = true;
            }
            if (!this.handshakeComplete) {
                ActiveMQClientLogger.LOGGER.httpHandshakeFailed(msg);
                ctx.close();
            }
            this.latch.countDown();
        }

        @Override
        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
            ActiveMQClientLogger.LOGGER.errorCreatingNettyConnection(cause);
            ctx.close();
        }

        public boolean awaitHandshake() {
            try {
                if (!this.latch.await(30000L, TimeUnit.MILLISECONDS)) {
                    return false;
                }
            }
            catch (InterruptedException e) {
                return false;
            }
            return this.handshakeComplete;
        }
    }

    private static final class ActiveMQClientChannelHandler
    extends ActiveMQChannelHandler {
        ActiveMQClientChannelHandler(ChannelGroup group, BufferHandler handler, ClientConnectionLifeCycleListener listener, Executor executor) {
            super(group, handler, listener, executor);
        }
    }
}

