package org.wildfly.security.auth.jaspi._private;

import java.util.Locale;
import java.lang.IllegalStateException;
import java.io.Serializable;
import javax.annotation.Generated;
import org.jboss.logging.DelegatingBasicLogger;
import javax.security.auth.message.AuthException;
import java.lang.SecurityException;
import java.lang.String;
import java.io.IOException;
import org.jboss.logging.Logger;
import javax.security.auth.message.AuthStatus;
import org.jboss.logging.BasicLogger;
import java.lang.Throwable;
import java.util.Arrays;
import java.lang.IllegalArgumentException;

/**
 * Warning this class consists of generated code.
 */
@Generated(value = "org.jboss.logging.processor.generator.model.MessageLoggerImplementor", date = "2022-01-17T17:06:10-0500")
public class ElytronMessages_$logger extends DelegatingBasicLogger implements ElytronMessages, BasicLogger, Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = ElytronMessages_$logger.class.getName();
    public ElytronMessages_$logger(final Logger log) {
        super(log);
    }
    private static final Locale LOCALE = Locale.ROOT;
    protected Locale getLoggingLocale() {
        return LOCALE;
    }
    protected String unableToConstructProvider$str() {
        return "ELY01167: Unable to construct provider '%s'.";
    }
    @Override
    public final SecurityException unableToConstructProvider(final String className, final Throwable cause) {
        final SecurityException result = new SecurityException(String.format(getLoggingLocale(), unableToConstructProvider$str(), className), cause);
        _copyStackTraceMinusOne(result);
        return result;
    }
    private static void _copyStackTraceMinusOne(final Throwable e) {
        final StackTraceElement[] st = e.getStackTrace();
        e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
    }
    protected String configAlreadyRegistered$str() {
        return "ELY01168: JASPIC Configuration for messageLayer=%s, and applicationContext=%s already registered.";
    }
    @Override
    public final IllegalStateException configAlreadyRegistered(final String messageLayer, final String applicationContext) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), configAlreadyRegistered$str(), messageLayer, applicationContext));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String unsupportedMessageType$str() {
        return "ELY01169: Message type '%s' is not supported by authentication module '%s'";
    }
    @Override
    public final IllegalArgumentException unsupportedMessageType(final String messageType, final String authenticationModule) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), unsupportedMessageType$str(), messageType, authenticationModule));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String unrecognisedAuthContextId$str() {
        return "ELY01170: Unrecognised authContextId '%s'";
    }
    @Override
    public final AuthException unrecognisedAuthContextId(final String authContextId) {
        final AuthException result = new AuthException(String.format(getLoggingLocale(), unrecognisedAuthContextId$str(), authContextId));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidMessageType$str() {
        return "ELY01171: Invalid message type '%s', expected '%s'.";
    }
    @Override
    public final IllegalArgumentException invalidMessageType(final String actualMessageType, final String expectedMessageType) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), invalidMessageType$str(), actualMessageType, expectedMessageType));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String messageDoesNotWrapExistingMessage$str() {
        return "ELY01172: Message does not wrap existing message of type '%s'";
    }
    @Override
    public final IllegalArgumentException messageDoesNotWrapExistingMessage(final String messageType) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), messageDoesNotWrapExistingMessage$str(), messageType));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String messageDoesNotUnWrapExistingMessage$str() {
        return "ELY01173: Message does not un-wrap existing message of type '%s'";
    }
    @Override
    public final IllegalArgumentException messageDoesNotUnWrapExistingMessage(final String messageType) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), messageDoesNotUnWrapExistingMessage$str(), messageType));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String messageSettingNotAllowed$str() {
        return "ELY01174: Setting message of type '%s' not allowed at this time.";
    }
    @Override
    public final IllegalStateException messageSettingNotAllowed(final String messageType) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), messageSettingNotAllowed$str(), messageType));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String messageWrappedWithoutSuccess$str() {
        return "ELY01175: The wrapping or request / response messages is only allowed where AuthStatus==SUCCESS ServerAuthenticationModule=%s";
    }
    @Override
    public final IllegalStateException messageWrappedWithoutSuccess(final String module) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), messageWrappedWithoutSuccess$str(), module));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidAuthStatus$str() {
        return "ELY01176: Invalid AuthStatus %s returned from ServerAuthModule %s.";
    }
    @Override
    public final IllegalStateException invalidAuthStatus(final AuthStatus authStatus, final String serverAuthModule) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), invalidAuthStatus$str(), authStatus, serverAuthModule));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String authorizationFailed$str() {
        return "ELY01177: Authorization failed.";
    }
    @Override
    public final IOException authorizationFailed() {
        final IOException result = new IOException(String.format(getLoggingLocale(), authorizationFailed$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
}
