/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.auth.realm;

import java.security.Principal;
import java.security.spec.AlgorithmParameterSpec;
import java.util.function.Function;
import org.wildfly.common.Assert;
import org.wildfly.security.auth.SupportLevel;
import org.wildfly.security.auth.realm.ElytronMessages;
import org.wildfly.security.auth.server.RealmIdentity;
import org.wildfly.security.auth.server.RealmUnavailableException;
import org.wildfly.security.auth.server.SecurityRealm;
import org.wildfly.security.auth.server.event.RealmAuthenticationEvent;
import org.wildfly.security.auth.server.event.RealmAuthorizationEvent;
import org.wildfly.security.auth.server.event.RealmEvent;
import org.wildfly.security.authz.AggregateAttributes;
import org.wildfly.security.authz.Attributes;
import org.wildfly.security.authz.AuthorizationIdentity;
import org.wildfly.security.credential.Credential;
import org.wildfly.security.evidence.Evidence;

public final class AggregateSecurityRealm
implements SecurityRealm {
    private final SecurityRealm authenticationRealm;
    private final SecurityRealm[] authorizationRealms;
    private final Function<Principal, Principal> principalTransformer;

    public AggregateSecurityRealm(SecurityRealm authenticationRealm, SecurityRealm authorizationRealm) {
        this.authenticationRealm = (SecurityRealm)Assert.checkNotNullParam((String)"authenticationRealm", (Object)authenticationRealm);
        Assert.checkNotNullParam((String)"authorizationRealm", (Object)authorizationRealm);
        this.authorizationRealms = new SecurityRealm[]{authorizationRealm};
        this.principalTransformer = null;
    }

    public AggregateSecurityRealm(SecurityRealm authenticationRealm, SecurityRealm ... authorizationRealms) {
        this.authenticationRealm = (SecurityRealm)Assert.checkNotNullParam((String)"authenticationRealm", (Object)authenticationRealm);
        this.authorizationRealms = (SecurityRealm[])Assert.checkNotNullParam((String)"authorizationRealms", (Object)authorizationRealms);
        this.principalTransformer = null;
    }

    public AggregateSecurityRealm(SecurityRealm authenticationRealm, Function<Principal, Principal> principalTransformer, SecurityRealm ... authorizationRealms) {
        this.authenticationRealm = (SecurityRealm)Assert.checkNotNullParam((String)"authenticationRealm", (Object)authenticationRealm);
        this.authorizationRealms = (SecurityRealm[])Assert.checkNotNullParam((String)"authorizationRealms", (Object)authorizationRealms);
        this.principalTransformer = principalTransformer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RealmIdentity getRealmIdentity(Evidence evidence) throws RealmUnavailableException {
        boolean ok = false;
        RealmIdentity authenticationIdentity = this.authenticationRealm.getRealmIdentity(evidence);
        ElytronMessages.log.tracef("Authentication identity for principal [%s] obtained.", (Object)evidence.getDecodedPrincipal());
        RealmIdentity[] authorizationIdentities = new RealmIdentity[this.authorizationRealms.length];
        try {
            for (int i = 0; i < authorizationIdentities.length; ++i) {
                SecurityRealm authorizationRealm = this.authorizationRealms[i];
                authorizationIdentities[i] = authorizationRealm == this.authenticationRealm ? authenticationIdentity : this.getAuthorizationIdentity(authorizationRealm, evidence, this.principalTransformer, authenticationIdentity);
                ElytronMessages.log.tracef("Authorization identity for principal [%s] obtained.", (Object)evidence.getDecodedPrincipal());
            }
            Identity identity = new Identity(authenticationIdentity, authorizationIdentities);
            ok = true;
            Identity identity2 = identity;
            return identity2;
        }
        finally {
            if (!ok) {
                authenticationIdentity.dispose();
                for (RealmIdentity current : authorizationIdentities) {
                    if (current == null) continue;
                    current.dispose();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RealmIdentity getRealmIdentity(Principal principal) throws RealmUnavailableException {
        boolean ok = false;
        RealmIdentity authenticationIdentity = this.authenticationRealm.getRealmIdentity(principal);
        ElytronMessages.log.tracef("Authentication identity for principal [%s] obtained.", (Object)principal);
        Principal authorizationPrincipal = principal;
        if (this.principalTransformer != null && (authorizationPrincipal = this.principalTransformer.apply(authorizationPrincipal)) == null) {
            throw ElytronMessages.log.transformedPrincipalCannotBeNull();
        }
        RealmIdentity[] authorizationIdentities = new RealmIdentity[this.authorizationRealms.length];
        try {
            for (int i = 0; i < authorizationIdentities.length; ++i) {
                SecurityRealm authorizationRealm = this.authorizationRealms[i];
                authorizationIdentities[i] = authorizationRealm == this.authenticationRealm && this.principalTransformer == null ? authenticationIdentity : authorizationRealm.getRealmIdentity(authorizationPrincipal);
                ElytronMessages.log.tracef("Authorization identity for principal [%s] obtained.", (Object)principal);
            }
            Identity identity = new Identity(authenticationIdentity, authorizationIdentities);
            ok = true;
            Identity identity2 = identity;
            return identity2;
        }
        finally {
            if (!ok) {
                authenticationIdentity.dispose();
                for (RealmIdentity current : authorizationIdentities) {
                    if (current == null) continue;
                    current.dispose();
                }
            }
        }
    }

    @Override
    public SupportLevel getCredentialAcquireSupport(Class<? extends Credential> credentialType, String algorithmName, AlgorithmParameterSpec parameterSpec) throws RealmUnavailableException {
        return this.authenticationRealm.getCredentialAcquireSupport(credentialType, algorithmName, parameterSpec);
    }

    @Override
    public SupportLevel getEvidenceVerifySupport(Class<? extends Evidence> evidenceType, String algorithmName) throws RealmUnavailableException {
        return this.authenticationRealm.getEvidenceVerifySupport(evidenceType, algorithmName);
    }

    private RealmIdentity getAuthorizationIdentity(SecurityRealm authorizationRealm, Evidence evidence, Function<Principal, Principal> principalTransformer, RealmIdentity authenticationIdentity) throws RealmUnavailableException {
        if (principalTransformer == null) {
            if (evidence.getPrincipal() == null) {
                return authorizationRealm.getRealmIdentity(authenticationIdentity.getRealmIdentityPrincipal());
            }
            return authorizationRealm.getRealmIdentity(evidence);
        }
        if (evidence.getPrincipal() == null) {
            Principal authorizationPrincipal = authenticationIdentity.getRealmIdentityPrincipal();
            if ((authorizationPrincipal = principalTransformer.apply(authorizationPrincipal)) == null) {
                throw ElytronMessages.log.transformedPrincipalCannotBeNull();
            }
            return authorizationRealm.getRealmIdentity(authorizationPrincipal);
        }
        return authorizationRealm.getRealmIdentity(evidence, principalTransformer);
    }

    @Override
    public void handleRealmEvent(RealmEvent event) {
        if (event instanceof RealmAuthenticationEvent) {
            this.authenticationRealm.handleRealmEvent(event);
        } else if (event instanceof RealmAuthorizationEvent) {
            for (SecurityRealm current : this.authorizationRealms) {
                SecurityRealm.safeHandleRealmEvent(current, event);
            }
        } else {
            SecurityRealm.safeHandleRealmEvent(this.authenticationRealm, event);
            for (SecurityRealm current : this.authorizationRealms) {
                SecurityRealm.safeHandleRealmEvent(current, event);
            }
        }
    }

    static final class Identity
    implements RealmIdentity {
        private final RealmIdentity authenticationIdentity;
        private final RealmIdentity[] authorizationIdentities;

        Identity(RealmIdentity authenticationIdentity, RealmIdentity[] authorizationIdentities) {
            this.authenticationIdentity = authenticationIdentity;
            this.authorizationIdentities = authorizationIdentities;
        }

        @Override
        public Principal getRealmIdentityPrincipal() {
            return this.authenticationIdentity.getRealmIdentityPrincipal();
        }

        @Override
        public SupportLevel getCredentialAcquireSupport(Class<? extends Credential> credentialType, String algorithmName, AlgorithmParameterSpec parameterSpec) throws RealmUnavailableException {
            return this.authenticationIdentity.getCredentialAcquireSupport(credentialType, algorithmName, parameterSpec);
        }

        @Override
        public SupportLevel getEvidenceVerifySupport(Class<? extends Evidence> evidenceType, String algorithmName) throws RealmUnavailableException {
            return this.authenticationIdentity.getEvidenceVerifySupport(evidenceType, algorithmName);
        }

        @Override
        public <C extends Credential> C getCredential(Class<C> credentialType, String algorithmName, AlgorithmParameterSpec parameterSpec) throws RealmUnavailableException {
            return this.authenticationIdentity.getCredential(credentialType, algorithmName, parameterSpec);
        }

        @Override
        public <C extends Credential> C getCredential(Class<C> credentialType, String algorithmName) throws RealmUnavailableException {
            return this.authenticationIdentity.getCredential(credentialType, algorithmName);
        }

        @Override
        public <C extends Credential> C getCredential(Class<C> credentialType) throws RealmUnavailableException {
            return this.authenticationIdentity.getCredential(credentialType);
        }

        @Override
        public boolean verifyEvidence(Evidence evidence) throws RealmUnavailableException {
            return this.authenticationIdentity.verifyEvidence(evidence);
        }

        @Override
        public boolean exists() throws RealmUnavailableException {
            return this.authenticationIdentity.exists();
        }

        @Override
        public AuthorizationIdentity getAuthorizationIdentity() throws RealmUnavailableException {
            if (this.authorizationIdentities.length == 1) {
                return this.authorizationIdentities[0].getAuthorizationIdentity();
            }
            AuthorizationIdentity[] authorizationIdentities = new AuthorizationIdentity[this.authorizationIdentities.length];
            for (int i = 0; i < authorizationIdentities.length; ++i) {
                authorizationIdentities[i] = this.authorizationIdentities[i].getAuthorizationIdentity();
            }
            return AuthorizationIdentity.basicIdentity(() -> this.combineAttributes(authorizationIdentities), "Aggregated");
        }

        private Attributes combineAttributes(AuthorizationIdentity[] authorizationIdentities) {
            Attributes[] attributes = new Attributes[authorizationIdentities.length];
            for (int i = 0; i < attributes.length; ++i) {
                attributes[i] = authorizationIdentities[i].getAttributes();
            }
            return AggregateAttributes.aggregateOf(attributes);
        }

        @Override
        public void dispose() {
            this.authenticationIdentity.dispose();
            for (RealmIdentity current : this.authorizationIdentities) {
                current.dispose();
            }
        }
    }
}

